/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui;

import com.valeras.color_combine.view.ColorPaletteView;
import com.valeras.color_combine.view.ColorWheelView;
import com.valeras.color_combine.view.GrayscaleColorTunerView;
import com.valeras.color_combine.view.VariateColorTunerView;
import com.valeras.colorimetry.CIE_ColourDifference;
import com.valeras.colorwheel_harmony.actions.EditColorComponentsAction;
import com.valeras.colorwheel_harmony.actions.SelectColorSchemeAction;
import com.valeras.colorwheel_harmony.app_core.ApplicationSettings;
import com.valeras.colorwheel_harmony.app_core.ApplicationView;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.model.ColorSpaceProvider;
import com.valeras.colorwheel_harmony.ui.ColorCombinePanel;
import com.valeras.colorwheel_harmony.ui.ColorSchemeSelectionPanel;
import com.valeras.colorwheel_harmony.ui.StatusBar;
import com.valeras.colorwheel_harmony.ui.model.ColorMatchingModel;
import com.valeras.colorwheel_harmony.ui.model.ImageColorPickerModel;
import com.valeras.colorwheel_harmony.ui.swing.AbstractColorWheelSkinFactory;
import com.valeras.colorwheel_harmony.ui.swing.PaletteLayoutProvider;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorComponent;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorPalette;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorWheel;
import com.valeras.colorwheel_harmony.ui.swing.windows.ColorChartWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.color.ColorSpace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public class ApplicationMainWindow
extends JFrame
implements ApplicationView,
PropertyChangeListener {
    private static final String STR_WINDOW_COLOR_CHART_TITLE = "window.color_chart.title";
    private static final Insets DEFAULT_INSETS = new Insets(0, 5, 0, 5);
    private final ColorCombinePanel cwPanel;
    private final ColorChartWindow colorChartWindow;
    private static final Color DARK_BACKGROUND = Color.gray;
    private final Color darkBackroundColor;
    private final Color defaultBackgroundColor;
    private ApplicationSettings settings;
    private final StatusBar statusBar;

    public ApplicationMainWindow() {
        this.setLayout(new BorderLayout());
        this.setLocationByPlatform(true);
        this.setResizable(false);
        this.settings = null;
        this.cwPanel = new ColorCombinePanel();
        this.cwPanel.setBorder(BorderFactory.createEmptyBorder(ApplicationMainWindow.DEFAULT_INSETS.top, ApplicationMainWindow.DEFAULT_INSETS.left, ApplicationMainWindow.DEFAULT_INSETS.bottom, ApplicationMainWindow.DEFAULT_INSETS.right));
        this.statusBar = new StatusBar();
        this.colorChartWindow = new ColorChartWindow(this);
        this.colorChartWindow.setTitle(StringTable.get(STR_WINDOW_COLOR_CHART_TITLE));
        this.colorChartWindow.setLocationByPlatform(true);
        this.add((Component)this.cwPanel, "Center");
        this.add((Component)this.statusBar, "South");
        this.defaultBackgroundColor = this.cwPanel.getBackground();
        this.darkBackroundColor = DARK_BACKGROUND;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    @Override
    public void selectColorTool(String name) {
        this.cwPanel.selectColorTool(name);
    }

    @Override
    public String getSelectedColorTool() {
        return this.cwPanel.getSelectedColorTool();
    }

    @Override
    public void viewInit(ColorCombineToolkit toolkit, ApplicationSettings settings) {
        this.settings = settings;
        JxColorComponent.setContrastColorProvider(new DefaultContrastColorProvider());
        this.cwPanel.setColorCombineToolkit(toolkit);
        if (settings.getDarkBackgroundEnabled()) {
            this.cwPanel.setBackground(this.darkBackroundColor);
            this.statusBar.setBackground(this.darkBackroundColor);
        }
        this.cwPanel.colorPalette.setLayout(PaletteLayoutProvider.getPaletteLayout(settings.getColorPaletteLayout()));
        this.cwPanel.colorSchemePanel.setSelectedButton(SelectColorSchemeAction.commandName(settings.getColorScheme()));
        this.cwPanel.colorWheel.setColorWheelSkin(AbstractColorWheelSkinFactory.createColorWheelSkin(settings.getColorWheelCover()));
        this.cwPanel.colorWheel.setSelectedColorVisible(settings.getLabelSelectedColorEnabled());
        this.cwPanel.colorWheel.setSampleColorsVisible(settings.getLabelPaletteColorsEnabled());
        this.cwPanel.colorMatching.setModel(new ColorMatchingModel(toolkit.getColorMatchingSystem(), CIE_ColourDifference.getInstance((int)1)));
        this.cwPanel.colorPalette.setColorPropertiesAction(new EditColorComponentsAction());
        this.settings.addPropertyChangeListener(this);
    }

    public ColorSchemeSelectionPanel getColorSchemeSelectionPanel() {
        return this.cwPanel.colorSchemePanel;
    }

    public JxColorWheel getColorWheelComponent() {
        return this.cwPanel.colorWheel;
    }

    public JxColorPalette getColorPaletteComponent() {
        return this.cwPanel.colorPalette;
    }

    @Override
    public ColorWheelView getColorWheelView() {
        return this.cwPanel.colorWheel;
    }

    @Override
    public ColorPaletteView getColorPaletteView() {
        return this.cwPanel.colorPalette;
    }

    @Override
    public VariateColorTunerView getVariateColorTunerView() {
        return this.cwPanel.variateTuner;
    }

    @Override
    public GrayscaleColorTunerView getGrayscaleColorTunerView() {
        return this.cwPanel.grayscaleTuner;
    }

    @Override
    public void setPaletteLayout(String layoutName) {
        this.cwPanel.colorPalette.setLayout(PaletteLayoutProvider.getPaletteLayout(layoutName));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String l_property = evt.getPropertyName();
        if (l_property.equals("label_selected_color")) {
            this.cwPanel.colorWheel.setSelectedColorVisible((Boolean)evt.getNewValue());
        } else if (l_property.equals("label_palette_colors")) {
            this.cwPanel.colorWheel.setSampleColorsVisible((Boolean)evt.getNewValue());
        } else if (l_property.equals("colorwheel_cover")) {
            this.cwPanel.colorWheel.setColorWheelSkin(AbstractColorWheelSkinFactory.createColorWheelSkin((String)evt.getNewValue()));
        } else if (l_property.equals("dark_background")) {
            Color l_color = (Boolean)evt.getNewValue() != false ? this.darkBackroundColor : this.defaultBackgroundColor;
            this.cwPanel.setBackground(l_color);
            this.statusBar.setBackground(l_color);
        }
    }

    @Override
    public ColorChartWindow getColorChartWindow() {
        return this.colorChartWindow;
    }

    @Override
    public ImageColorPickerModel getImageColorPickerModel() {
        return this.cwPanel.colorPicker.getModel();
    }

    private class DefaultContrastColorProvider
    implements JxColorComponent.ContrastColorProvider {
        private final ColorSpace csLab = ColorSpaceProvider.getInstance().provide("CS_CIELab");
        private final float whiteL = this.csLab.fromRGB(Color.white.getColorComponents(null))[0];
        private final float blackL = this.csLab.fromRGB(Color.black.getColorComponents(null))[0];

        @Override
        public Color provide(Color sample) {
            float l_ls = this.csLab.fromRGB(sample.getColorComponents(null))[0];
            return Math.abs(l_ls - this.whiteL) > Math.abs(l_ls - this.blackL) ? Color.white : Color.black;
        }
    }
}

