/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.model.filters;

import com.valeras.colorimetry.CIE_ColourDifference;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchColorCardFilter {
    private static final float MAX_DELTA = 0.01f;
    private ArrayList<ColorStroke>[] scanLines;
    private ArrayList<ColorShape> shapes;
    private final CIE_ColourDifference formula;
    private final int minExtent;
    private ColorCard sample;

    public SearchColorCardFilter(CIE_ColourDifference formula, int minExtent) {
        this.formula = formula;
        this.minExtent = minExtent;
        this.scanLines = null;
        this.sample = null;
    }

    public Shape getSampleShape() {
        return this.sample != null ? this.sample.shape : null;
    }

    public Color getSampleColor() {
        return this.sample != null ? this.sample.color : null;
    }

    private static float delta(Color c1, Color c2) {
        float[] l_colorComponents1 = c1.getColorComponents(null);
        float[] l_colorComponents2 = c2.getColorComponents(null);
        float l_delta = (Math.abs(l_colorComponents1[0] - l_colorComponents2[0]) + Math.abs(l_colorComponents1[1] - l_colorComponents2[1]) + Math.abs(l_colorComponents1[2] - l_colorComponents2[2])) / 3.0f;
        return l_delta;
    }

    public Shape filter(BufferedImage image, Color color, boolean outline) {
        float l_diff;
        int i;
        Graphics2D l_gr = image.createGraphics();
        ColorStroke l_stroke = null;
        ColorShape l_shape = null;
        float l_minDiff = -1.0f;
        ArrayList<ShapeDimension> l_shapeDims = new ArrayList<ShapeDimension>();
        int l_width = image.getWidth();
        int l_height = image.getHeight();
        this.shapes = new ArrayList();
        this.scanLines = new ArrayList[l_height];
        for (i = 0; i < this.scanLines.length; ++i) {
            this.scanLines[i] = new ArrayList();
        }
        for (int y = 0; y < l_height; ++y) {
            for (int x = 0; x < l_width; ++x) {
                Color l_color = new Color(image.getRGB(x, y));
                if (l_stroke != null) {
                    l_diff = SearchColorCardFilter.delta(l_stroke.getColor(), l_color);
                    if (l_diff < 0.01f) {
                        l_stroke.add(l_color);
                        continue;
                    }
                    this.acceptStroke(l_stroke);
                    l_stroke = new ColorStroke(l_color, x, y);
                    continue;
                }
                l_stroke = new ColorStroke(l_color, x, y);
            }
            this.acceptStroke(l_stroke);
            l_stroke = null;
        }
        this.acceptStroke(l_stroke);
        for (i = 0; i < l_height; ++i) {
            for (ColorStroke stroke : this.scanLines[i]) {
                boolean l_continue = true;
                l_shape = new ColorShape(stroke);
                block5: for (int j = i + 1; j < l_height && l_continue; ++j) {
                    l_continue = false;
                    for (ColorStroke s : this.scanLines[j]) {
                        if (!l_shape.accepts(s)) continue;
                        l_shape.add(s);
                        l_continue = true;
                        continue block5;
                    }
                }
                this.acceptShape(l_shape);
            }
        }
        for (ColorShape shape : this.shapes) {
            Iterator l_it = l_shapeDims.iterator();
            boolean l_accepted = false;
            while (l_it.hasNext()) {
                ShapeDimension l_dim = (ShapeDimension)l_it.next();
                if (!l_dim.accepts(shape)) continue;
                l_dim.add(shape);
                l_accepted = true;
                break;
            }
            if (l_accepted) continue;
            l_shapeDims.add(new ShapeDimension(shape));
        }
        Collections.sort(l_shapeDims);
        Collections.reverse(l_shapeDims);
        ShapeDimension l_bestShape = (ShapeDimension)l_shapeDims.get(0);
        Iterator<ColorShape> l_it = this.shapes.iterator();
        while (l_it.hasNext()) {
            l_shape = l_it.next();
            if (l_bestShape.accepts(l_shape)) continue;
            l_it.remove();
        }
        l_gr.setColor(Color.cyan);
        for (ColorShape shape : this.shapes) {
            l_gr.draw(shape.getShape().getBounds());
        }
        l_shape = null;
        for (ColorShape s : this.shapes) {
            l_diff = this.formula.delta(color, s.getColor());
            if (l_minDiff != -1.0f && !(l_diff < l_minDiff)) continue;
            l_minDiff = l_diff;
            l_shape = s;
        }
        ColorCard colorCard = this.sample = l_shape != null ? new ColorCard(l_shape.getShape(), l_shape.getColor()) : null;
        if (outline && l_shape != null) {
            l_gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.outline(l_gr, l_shape, Color.red);
        }
        l_gr.dispose();
        return this.sample != null ? this.sample.shape : null;
    }

    private void outline(Graphics2D gr, ColorShape shape, Color color) {
        Rectangle l_rect = shape.getShape().getBounds();
        double l_radius = new Point2D.Double(l_rect.getMinX(), l_rect.getMinY()).distance(l_rect.getMaxX(), l_rect.getMaxY());
        float l_width = (float)(l_radius / 50.0);
        Arc2D.Double l_shape = new Arc2D.Double(l_rect.getCenterX() - l_radius / 2.0, l_rect.getCenterY() - l_radius / 2.0, l_radius, l_radius, 0.0, 360.0, 1);
        gr.setColor(color);
        gr.setStroke(new BasicStroke(l_width > 1.5f ? l_width : 1.5f));
        gr.draw(l_shape);
    }

    private void acceptStroke(ColorStroke stroke) {
        if (stroke != null && stroke.getLength() >= this.minExtent) {
            this.scanLines[stroke.y].add(stroke);
        }
    }

    private void acceptShape(ColorShape shape) {
        if (shape.getCount() >= this.minExtent) {
            ArrayList<ColorStroke> l_strokes = shape.getStrokes();
            for (int i = 1; i < l_strokes.size(); ++i) {
                ColorStroke l_stroke = l_strokes.get(i);
                boolean l_removed = this.scanLines[l_stroke.y].remove(l_stroke);
                if (l_removed) continue;
                Logger.getLogger(SearchColorCardFilter.class.getName()).log(Level.WARNING, null, "Can't remove stroke on scan line #" + l_stroke.y);
            }
            this.shapes.add(shape);
        }
    }

    private static class ShapeDimension
    implements Comparable {
        private final Dimension size;
        private int count;

        public ShapeDimension(ColorShape shape) {
            Rectangle l_bounds = shape.getShape().getBounds();
            this.size = new Dimension((int)l_bounds.getWidth(), (int)l_bounds.getHeight());
            this.count = 1;
        }

        public void add(ColorShape shape) {
            Rectangle l_bounds = shape.getShape().getBounds();
            int l_width = (int)l_bounds.getWidth();
            int l_height = (int)l_bounds.getHeight();
            l_width = (l_width * this.count + this.size.width) / (this.count + 1);
            l_height = (l_height * this.count + this.size.height) / (this.count + 1);
            this.size.setSize(l_width, l_height);
            ++this.count;
        }

        public boolean accepts(ColorShape shape) {
            Rectangle l_bounds = shape.getShape().getBounds();
            int l_margin = 5;
            if (Math.abs((double)this.size.width - l_bounds.getWidth()) > (double)(this.size.width / l_margin)) {
                return false;
            }
            return !(Math.abs((double)this.size.height - l_bounds.getHeight()) > (double)(this.size.height / l_margin));
        }

        public int compareTo(Object o) {
            ShapeDimension l_dim2 = (ShapeDimension)o;
            return this.count - l_dim2.count;
        }

        public String toString() {
            return "ShapeDimension{size=" + this.size + "count=" + this.count + '}';
        }
    }

    private class ColorShape {
        private final ArrayList<ColorStroke> strokes = new ArrayList();
        private Color color;
        private int cx;
        private int length;

        public ColorShape(ColorStroke stroke) {
            this.strokes.add(stroke);
            this.color = stroke.getColor();
            this.cx = stroke.getCenter();
            this.length = stroke.getLength();
        }

        public ArrayList<ColorStroke> getStrokes() {
            return this.strokes;
        }

        public void add(ColorStroke stroke) {
            int l_count = this.strokes.size();
            float[] l_colorComponents = this.color.getColorComponents(null);
            float[] l_colorComponents2 = stroke.getColor().getColorComponents(null);
            for (int i = 0; i < 3; ++i) {
                l_colorComponents[i] = (l_colorComponents[i] * (float)l_count + l_colorComponents2[i]) / (float)(l_count + 1);
            }
            this.strokes.add(stroke);
            this.color = new Color(l_colorComponents[0], l_colorComponents[1], l_colorComponents[2]);
            this.cx = (this.cx * l_count + stroke.getCenter()) / (l_count + 1);
            this.length = (this.length * l_count + stroke.getLength()) / (l_count + 1);
        }

        public Color getColor() {
            return this.color;
        }

        public int getCX() {
            return this.cx;
        }

        public int getCount() {
            return this.strokes.size();
        }

        public Shape getShape() {
            int i;
            Path2D.Float l_path = new Path2D.Float();
            int l_count = this.strokes.size();
            ColorStroke l_stroke = this.strokes.get(0);
            ((Path2D)l_path).moveTo(l_stroke.x, l_stroke.y);
            for (i = 1; i < l_count; ++i) {
                l_stroke = this.strokes.get(i);
                ((Path2D)l_path).lineTo(l_stroke.x, l_stroke.y);
            }
            for (i = l_count - 1; i >= 0; --i) {
                l_stroke = this.strokes.get(i);
                ((Path2D)l_path).lineTo(l_stroke.x + l_stroke.length, l_stroke.y);
            }
            l_path.closePath();
            return l_path;
        }

        public boolean accepts(ColorStroke stroke) {
            int l_margin = 5;
            if (Math.abs(this.cx - stroke.getCenter()) > this.length / 5) {
                return false;
            }
            if (Math.abs(this.length - stroke.getLength()) > this.length / 5) {
                return false;
            }
            float l_diff = SearchColorCardFilter.delta(this.color, stroke.getColor());
            return !(l_diff > 0.01f);
        }
    }

    protected static class ColorCard {
        public final Shape shape;
        public final Color color;

        public ColorCard(Shape shape, Color color) {
            this.shape = shape;
            this.color = color;
        }
    }

    private class ColorStroke {
        private Color color;
        private final int x;
        private final int y;
        private int length;

        public ColorStroke(Color color, int x, int y) {
            this.color = color;
            this.x = x;
            this.y = y;
            this.length = 1;
        }

        public void add(Color color2) {
            float[] l_colorComponents = this.color.getColorComponents(null);
            float[] l_colorComponents2 = color2.getColorComponents(null);
            for (int i = 0; i < 3; ++i) {
                l_colorComponents[i] = (l_colorComponents[i] * (float)this.length + l_colorComponents2[i]) / (float)(this.length + 1);
            }
            this.color = new Color(l_colorComponents[0], l_colorComponents[1], l_colorComponents[2]);
            ++this.length;
        }

        public Color getColor() {
            return this.color;
        }

        public int getLength() {
            return this.length;
        }

        public int getCenter() {
            return this.x + this.length / 2;
        }
    }
}

