/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.model.filters;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class SeamlessTextureFilter {
    public BufferedImage create(BufferedImage image) {
        return SeamlessTextureFilter.createSeamlessTexture(image);
    }

    public static BufferedImage createSeamlessTexture(BufferedImage image) {
        boolean INTERPOLATION_TYPE = true;
        int l_type = image.getType() != 0 ? image.getType() : 1;
        int l_width = image.getWidth();
        int l_height = image.getHeight();
        BufferedImage l_texture = new BufferedImage(l_width * 2, l_height * 2, l_type);
        Graphics2D l_gr = l_texture.createGraphics();
        l_gr.drawImage(image, null, 0, l_height);
        AffineTransform l_tx = AffineTransform.getScaleInstance(1.0, -1.0);
        l_tx.translate(0.0, -l_height);
        AffineTransformOp l_op = new AffineTransformOp(l_tx, 1);
        l_gr.drawImage(image, l_op, 0, 0);
        l_tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        l_tx.translate(-l_width, 0.0);
        l_op = new AffineTransformOp(l_tx, 1);
        l_gr.drawImage(image, l_op, l_width, l_height);
        l_tx = AffineTransform.getScaleInstance(-1.0, -1.0);
        l_tx.translate(-l_width, -l_height);
        l_op = new AffineTransformOp(l_tx, 1);
        l_gr.drawImage(image, l_op, l_width, 0);
        l_gr.dispose();
        return l_texture;
    }
}

