/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.model.filters;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BoundedRangeModel;

public class ExtractColorFilter {
    private static final int BUFFER_SIZE = 1024;
    private static final int RESOLUTION_REDUCE = 1024;
    private static final float NEAREST = 0.01f;
    private static final float PROXY_DIST = 0.02f;
    private static final float NOISE_LEVEL = 0.05f;
    private final ColorBar[] buffer = new ColorBar[1024];
    private int bufferSize;
    private final BoundedRangeModel rangeModel;

    public ExtractColorFilter(BoundedRangeModel boundedRangeModel) {
        this.rangeModel = boundedRangeModel;
    }

    protected void updateRangeModel(int step, float value) {
    }

    public Color[] extract(BufferedImage image, int numColors) {
        this.updateRangeModel(0, 0.0f);
        long l_time = System.currentTimeMillis();
        this.loadColors(image);
        System.out.println("time: load=" + (float)(System.currentTimeMillis() - l_time) / 1000.0f + " sec");
        l_time = System.currentTimeMillis();
        ArrayList<ColorBar> l_values = this.extractPeaks();
        System.out.println("time: extract=" + (float)(System.currentTimeMillis() - l_time) / 1000.0f + " sec");
        Collections.sort(l_values, new ColorBarComparator());
        Collections.reverse(l_values);
        Color[] l_colors = new Color[l_values.size()];
        for (int i = 0; i < l_values.size(); ++i) {
            l_colors[i] = new Color(l_values.get((int)i).rgb);
        }
        return l_colors;
    }

    protected void loadColors(BufferedImage image) {
        this.bufferSize = 0;
        int l_width = image.getWidth();
        int l_height = image.getHeight();
        int l_step = l_height / 1024 + 1;
        int l_step2 = l_width / 1024 + 1;
        System.out.println("step=" + l_step + ", drop=" + l_step2);
        for (int r = 0; r < l_height; r += l_step) {
            for (int c = 0; c < l_width; c += l_step2) {
                float l_minDist = -1.0f;
                int l_minValue = -1;
                int l_index = -1;
                int l_replaceIndex = -1;
                int l_rgb = image.getRGB(c, r);
                if (this.isGray(l_rgb)) continue;
                for (int i = 0; i < this.bufferSize; ++i) {
                    float l_dist = this.distance(l_rgb, this.buffer[i].rgb);
                    if ((l_minDist == -1.0f || l_dist < l_minDist) && l_dist < 0.01f) {
                        l_index = i;
                        l_minDist = l_dist;
                        break;
                    }
                    int l_value = this.buffer[i].count;
                    if (l_minValue != -1 && l_value >= l_minValue) continue;
                    l_minValue = l_value;
                    l_replaceIndex = i;
                }
                if (l_index >= 0) {
                    this.putColor(this.buffer[l_index], l_rgb);
                    continue;
                }
                if (this.bufferSize < 1024) {
                    this.buffer[this.bufferSize++] = new ColorBar(l_rgb, 1);
                    continue;
                }
                this.buffer[l_replaceIndex] = new ColorBar(l_rgb, 1);
            }
        }
    }

    protected ArrayList<ColorBar> extractPeaks() {
        float l_dist;
        ColorBar l_cv2;
        int j;
        ColorBar l_cv;
        int i;
        int l_maxValue;
        ArrayList<ColorBar> l_colors = new ArrayList<ColorBar>();
        int l_fallCount = 0;
        ColorBarComparator l_comparator = new ColorBarComparator();
        int l_minValue = l_maxValue = this.buffer[0].count;
        for (i = 0; i < this.bufferSize; ++i) {
            l_cv = this.buffer[i];
            if (l_cv.count > l_maxValue) {
                l_maxValue = l_cv.count;
            }
            if (l_cv.count < l_minValue) {
                l_minValue = l_cv.count;
            }
            for (j = i + 1; j < this.bufferSize; ++j) {
                l_cv2 = this.buffer[j];
                l_dist = this.distance(l_cv.rgb, l_cv2.rgb);
                if (!(l_dist < 0.02f) || l_cv.count >= l_cv2.count) continue;
                l_cv.fall = true;
                ++l_fallCount;
            }
        }
        System.out.println("falls=" + l_fallCount + ", min=" + l_minValue + ", max=" + l_maxValue);
        int l_noiseLevel = 0;
        for (i = 0; i < this.bufferSize; ++i) {
            l_cv = this.buffer[i];
            if (l_cv.isFall() || l_cv.count <= l_noiseLevel) continue;
            l_cv.value = (float)l_cv.count / (float)l_maxValue;
            l_colors.add(l_cv);
        }
        int l_size = l_colors.size();
        for (i = 0; i < l_size; ++i) {
            l_cv = (ColorBar)l_colors.get(i);
            for (j = i + 1; j < l_size; ++j) {
                l_cv2 = (ColorBar)l_colors.get(j);
                l_dist = this.distance(l_cv.rgb, l_cv2.rgb);
                l_cv.dist += l_dist;
                l_cv2.dist += l_dist;
            }
            l_cv.dist /= (float)(l_size - 1);
        }
        System.out.println("buffer=" + this.bufferSize + ", array=" + l_colors.size());
        for (i = 0; i < l_colors.size(); ++i) {
            System.out.println("[" + i + "] " + l_colors.get(i) + ", RATE=" + l_comparator.rate(l_colors.get(i)));
        }
        return l_colors;
    }

    protected boolean isGray(int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        return r == g && g == b;
    }

    private void putColor(ColorBar base, int color) {
        int l_value = base.count++;
        int MAX_VALUE = 255;
        float[] l_rgb = this.getRGBColorComponents(base.rgb);
        float[] l_rgb2 = this.getRGBColorComponents(color);
        int l_r = Math.round((l_rgb[0] * (float)l_value + l_rgb2[0]) / (float)(l_value + 1) * 255.0f);
        int l_g = Math.round((l_rgb[1] * (float)l_value + l_rgb2[1]) / (float)(l_value + 1) * 255.0f);
        int l_b = Math.round((l_rgb[2] * (float)l_value + l_rgb2[2]) / (float)(l_value + 1) * 255.0f);
        base.rgb = l_r << 16 | l_g << 8 | l_b;
    }

    protected float distance(int c1, int c2) {
        float[] l_rgb1 = this.getRGBColorComponents(c1);
        float[] l_rgb2 = this.getRGBColorComponents(c2);
        float l_r = l_rgb2[0] - l_rgb1[0];
        float l_g = l_rgb2[1] - l_rgb1[1];
        float l_b = l_rgb2[2] - l_rgb1[2];
        return (float)Math.sqrt(l_r * l_r + l_g * l_g + l_b * l_b);
    }

    protected float[] getRGBColorComponents(int rgb) {
        float[] l_components = new float[3];
        float MAX_VALUE = 255.0f;
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        l_components[0] = (float)r / 255.0f;
        l_components[1] = (float)g / 255.0f;
        l_components[2] = (float)b / 255.0f;
        return l_components;
    }

    private class ColorBarComparator
    implements Comparator {
        private ColorBarComparator() {
        }

        public int compare(Object o1, Object o2) {
            return (int)((this.rate((ColorBar)o1) - this.rate((ColorBar)o2)) * 100.0f);
        }

        private float rate(ColorBar bar) {
            Color l_color = new Color(bar.rgb);
            float l_saturation = Color.RGBtoHSB(l_color.getRed(), l_color.getGreen(), l_color.getBlue(), null)[1];
            return (bar.value + bar.dist * 4.0f + l_saturation) / 3.0f;
        }
    }

    private static class ColorBar {
        public int rgb;
        public int count;
        public boolean fall;
        public float dist;
        public float value;

        public ColorBar(int rgb, int count) {
            this.rgb = rgb;
            this.count = count;
            this.fall = false;
            this.dist = 0.0f;
            this.value = 0.0f;
        }

        public boolean isFall() {
            return this.fall;
        }

        public String toString() {
            return "ColorBar{rgb=" + this.rgb + " count=" + this.count + " fall=" + this.fall + " dist=" + this.dist + " value=" + this.value + '}';
        }
    }
}

