/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.model;

import com.valeras.color_chart.ColorChart;
import com.valeras.color_chart.ColorLookupTable;
import com.valeras.colorimetry.CIELab_ColorSpace;
import com.valeras.colorimetry.CIE_ColourDifference;
import com.valeras.colorwheel_harmony.model.ColorChartManager;
import com.valeras.colorwheel_harmony.resources.HarmonyResources;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ColorSpaceProvider {
    public static final int TYPE_MASTER_CS = 1;
    public static final int TYPE_MATCHING_CS = 2;
    public static final String CS_sRGB = "CS_sRGB";
    public static final String CS_CMYK = "CS_CMYK";
    public static final String CS_CIELab = "CS_CIELab";
    private static ColorSpaceProvider instance = null;
    private static final String ICC_FOLDER = "icc_profiles/";
    private static final String CMYK_DIRECTORY = "icc_profiles/cmyk_directory.properties";
    private static final String PROFILE_NAMES = "icc_profiles/profile_names.properties";
    private static final List<String> cmykDirectory = new ArrayList<String>();
    private static final Map<String, String> cmykProfiles = new HashMap<String, String>();
    private static Map<String, String> profileNames = null;
    protected final Map<String, ColorSpace> colorSpaceMap = new HashMap<String, ColorSpace>();
    private ColorChartManager colorChartManager = new ColorChartManager();
    private String cmykProfile = null;

    public static ColorSpaceProvider getInstance() {
        if (instance == null) {
            instance = new ColorSpaceProvider();
        }
        if (profileNames == null) {
            profileNames = ColorSpaceProvider.loadICCProfileNames();
            try {
                ColorSpaceProvider.loadCMYKProfileDirectory(cmykDirectory, cmykProfiles);
            }
            catch (IOException ex) {
                Logger.getLogger(ColorSpaceProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return instance;
    }

    protected ColorSpaceProvider() {
        this.addColorSpace(CS_sRGB, ColorSpace.getInstance(1000));
        this.addColorSpace(CS_CIELab, (ColorSpace)CIELab_ColorSpace.getInstance());
        ColorLookupTable.setColorDifferenceFormula((ColorLookupTable.ColorDifferenceFormula)new DefaultColorDifferenceFormula());
    }

    public final void addColorSpace(String name, ColorSpace colorSpace) {
        this.colorSpaceMap.put(name, colorSpace);
    }

    public Set<Map.Entry<String, ColorSpace>> getMasterSet() {
        return this.colorSpaceMap.entrySet();
    }

    public void setCMYKProfile(String name) {
        String l_file = cmykProfiles.get(name);
        if (l_file == null) {
            Logger.getLogger(ColorSpaceProvider.class.getName()).log(Level.SEVERE, "No such CMYK profile:{0}", name);
            l_file = cmykProfiles.get(cmykDirectory.get(0));
        }
        ICC_ColorSpace l_cs = this.createICC_ColorSpace(l_file);
        this.cmykProfile = name;
        this.addColorSpace(CS_CMYK, l_cs);
    }

    public String getCMYKProfile() {
        return this.cmykProfile;
    }

    public String getProfileName(String profile) {
        return profileNames.get(profile);
    }

    public List<String> listCMYKProfiles() {
        return Collections.unmodifiableList(cmykDirectory);
    }

    public ColorChartManager getColorChartManager() {
        return this.colorChartManager;
    }

    public ColorSpace provide(String name) {
        ColorSpace l_cs = null;
        l_cs = ColorSpaceProvider.getInstance().colorSpaceMap.get(name);
        if (l_cs == null) {
            l_cs = this.colorChartManager.getColorChart(name);
        }
        return l_cs;
    }

    public static String nameOf(ColorSpace colorSpace) {
        String l_name = null;
        if (colorSpace == null) {
            return null;
        }
        Set<Map.Entry<String, ColorSpace>> l_entries = ColorSpaceProvider.getInstance().colorSpaceMap.entrySet();
        for (Map.Entry<String, ColorSpace> e : l_entries) {
            if (!colorSpace.equals(e.getValue())) continue;
            l_name = e.getKey();
            break;
        }
        if (l_name == null && colorSpace instanceof ColorChart) {
            l_name = ((ColorChart)colorSpace).getName();
        }
        return l_name;
    }

    protected final ICC_ColorSpace createICC_ColorSpace(String name) {
        ICC_Profile l_profile = null;
        try {
            l_profile = this.loadICC_Profile(name);
        }
        catch (IOException ex) {
            Logger.getLogger(ColorSpaceProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        ICC_ColorSpace l_cs = new ICC_ColorSpace(l_profile);
        return l_cs;
    }

    private ICC_Profile loadICC_Profile(String name) throws IOException {
        InputStream l_stream = HarmonyResources.class.getResourceAsStream(ICC_FOLDER + name);
        ICC_Profile l_profile = ICC_Profile.getInstance(l_stream);
        if (l_stream != null) {
            l_stream.close();
        }
        return l_profile;
    }

    private static void loadCMYKProfileDirectory(List<String> directory, Map<String, String> profiles) throws IOException {
        String l_text;
        InputStream l_stream = HarmonyResources.class.getResourceAsStream(CMYK_DIRECTORY);
        BufferedReader l_br = new BufferedReader(new InputStreamReader(l_stream));
        while ((l_text = l_br.readLine()) != null) {
            int l_index = l_text.indexOf("=");
            if (l_index <= 0) {
                Logger.getLogger(ColorSpaceProvider.class.getName()).log(Level.WARNING, "Error parsing: ", l_text);
                continue;
            }
            String l_name = l_text.substring(0, l_index).trim();
            String l_profile = l_text.substring(l_index + 1).trim();
            if (l_name.startsWith("#")) continue;
            directory.add(l_name);
            profiles.put(l_name, l_profile);
        }
        l_br.close();
    }

    private static Map<String, String> loadICCProfileNames() {
        Properties l_properties = new Properties();
        InputStream l_stream = HarmonyResources.class.getResourceAsStream(PROFILE_NAMES);
        try {
            l_properties.load(l_stream);
        }
        catch (IOException ex) {
            Logger.getLogger(ColorSpaceProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (l_stream != null) {
            try {
                l_stream.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ColorSpaceProvider.class.getName()).log(Level.WARNING, null, ex);
            }
        }
        return new HashMap<Object, Object>(l_properties);
    }

    private static class DefaultColorDifferenceFormula
    implements ColorLookupTable.ColorDifferenceFormula {
        private final CIE_ColourDifference formula = CIE_ColourDifference.getInstance((int)2);

        public float delta(Color c1, Color c2) {
            return this.formula.delta(c1, c2);
        }
    }
}

