/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.model;

import com.valeras.cns.ColorNamingSystem;
import com.valeras.color_chart.ColorChart;
import com.valeras.color_chart.ColorChartEntry;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.model.ColorCoding;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ColorDetails {
    private static final Map<CSColor, ColorDetails> detailsCache = new HashMap<CSColor, ColorDetails>();
    private static int cacheHitCounter;
    private static int cacheMissCounter;
    private static ColorNamingSystem ucl;
    private final Color color;
    private ColorChartEntry entry = null;
    private String name = null;
    private String code = null;
    private String value = null;
    private final Map<Locale, String> localizedNames = new HashMap<Locale, String>();

    public ColorDetails(Color color) {
        this.color = color;
    }

    public ColorDetails(Color color, String name) {
        this.color = color;
        this.name = name;
    }

    public ColorDetails(Color color, String name, String systemCode) {
        this.color = color;
        this.name = name;
        this.code = systemCode;
    }

    public boolean isColorChartEntry() {
        return this.entry != null;
    }

    public ColorChartEntry getColorChartEntry() {
        return this.entry;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Color getColor() {
        return this.color;
    }

    public void addDisplayNames(Set<Map.Entry<Locale, String>> names) {
        for (Map.Entry<Locale, String> e : names) {
            this.localizedNames.put(e.getKey(), e.getValue());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        String l_name = this.getName();
        if (this.localizedNames.containsKey(locale)) {
            l_name = this.localizedNames.get(locale);
        } else {
            Set<Locale> l_locales = this.localizedNames.keySet();
            for (Locale l : l_locales) {
                if (!locale.getLanguage().equals(l.getLanguage())) continue;
                l_name = this.localizedNames.get(l);
                break;
            }
        }
        return l_name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDetailedName() {
        String l_text = this.name != null ? (this.code != null ? this.name + " (" + this.code + ")" : this.name) : this.code;
        return l_text;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColorDetails) {
            return this.color.equals(((ColorDetails)obj).getColor());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.color != null ? this.color.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "color=" + this.color + ", name='" + this.name + "', code=" + this.code + "', value=" + this.value;
    }

    public static void setUCL(ColorNamingSystem ucl) {
        ColorDetails.ucl = ucl;
    }

    public static ColorDetails getDetails(Color color) {
        ColorDetails l_details = null;
        CSColor l_key = new CSColor(color);
        if (detailsCache.containsKey(l_key)) {
            l_details = detailsCache.get(l_key);
            ++cacheHitCounter;
        } else {
            l_details = new ColorDetails(color);
            l_details = ColorDetails.extractDetails(color, l_details);
            detailsCache.put(l_key, l_details);
            ++cacheMissCounter;
        }
        return l_details;
    }

    private static ColorDetails extractDetails(Color color, ColorDetails details) {
        ColorSpace l_cs;
        String l_name = null;
        String l_code = null;
        String l_value = null;
        Object l_displayNames = null;
        if (details == null) {
            details = new ColorDetails(color);
        }
        if ((l_cs = color.getColorSpace()) != null && l_cs instanceof ColorChart) {
            ColorChartEntry l_entry;
            ColorChart l_cs2 = (ColorChart)l_cs;
            String l_id = l_cs2.identifierOf(color);
            if (l_id != null) {
                l_entry = l_cs2.getEntry(l_id);
            } else {
                l_entry = l_cs2.getNearestEntry(color);
                Logger.getLogger(ColorDetails.class.getName()).log(Level.WARNING, "{0} provides inaccurate color value {1}, found nearest entry={2}", new Object[]{l_cs2.getName(), color, l_entry});
            }
            details.entry = l_entry;
            l_name = l_entry.getDisplayName();
            l_code = l_entry.getCode();
            l_value = l_entry.getValue();
            l_displayNames = null;
        } else {
            l_value = ColorCoding.codeOf(color) + "h";
            if (ucl != null) {
                l_name = ucl.displayNameOf(color, StringTable.getLocale());
            }
        }
        details.setName(l_name);
        details.setCode(l_code);
        details.setValue(l_value);
        if (l_displayNames != null) {
            details.addDisplayNames(l_displayNames);
        }
        return details;
    }

    public static void optimizeCache(Color[] colors) {
        ArrayList<Color> l_colors = new ArrayList<Color>();
        for (Color c : colors) {
            if (c == null) continue;
            l_colors.add(c);
        }
        Color[] l_liveColors = l_colors.toArray(new Color[l_colors.size()]);
        Arrays.sort(l_liveColors, new ColorComparator());
        Set<CSColor> l_keys = detailsCache.keySet();
        Iterator<CSColor> l_it = l_keys.iterator();
        while (l_it.hasNext()) {
            int l_index = Arrays.binarySearch(l_liveColors, l_it.next().getColor(), new ColorComparator());
            if (l_index >= 0) continue;
            l_it.remove();
        }
    }

    public static CacheStatistics getCacheStatistics() {
        return new CacheStatistics(cacheHitCounter, cacheMissCounter, detailsCache.size());
    }

    static {
        ucl = null;
        cacheHitCounter = 0;
        cacheMissCounter = 0;
    }

    private static class CSColor {
        private final Color color;
        private final ColorSpace cs;

        public CSColor(Color color) {
            this.color = color;
            this.cs = color.getColorSpace();
        }

        public Color getColor() {
            return this.color;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CSColor)) {
                return false;
            }
            ColorSpace l_cs2 = ((CSColor)obj).getColor().getColorSpace();
            if (this.cs != null ? !this.cs.equals(l_cs2) : l_cs2 != null) {
                return false;
            }
            return this.color.equals(((CSColor)obj).getColor());
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.color != null ? this.color.hashCode() : 0);
            hash = 79 * hash + (this.cs != null ? this.cs.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.color.toString();
        }
    }

    private static class ColorComparator
    implements Comparator<Color> {
        private ColorComparator() {
        }

        @Override
        public int compare(Color o1, Color o2) {
            return o1.getRGB() - o2.getRGB();
        }
    }

    public static class CacheStatistics {
        private final int hits;
        private final int misses;
        private final int size;

        protected CacheStatistics(int hits, int misses, int size) {
            this.hits = hits;
            this.misses = misses;
            this.size = size;
        }

        public String toString() {
            return ColorDetails.class.getName() + ": Cache statistics: hits=" + this.hits + ", misses=" + this.misses + ", size=" + this.size + ";";
        }
    }
}

