/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.model;

import com.valeras.color_chart.ColorChart;
import com.valeras.color_combine.AbstractColorCombineToolkit;
import com.valeras.color_combine.controller.ColorWheelController;
import com.valeras.color_combine.model.ColorPalette;
import com.valeras.color_combine.model.ColorWheel;
import com.valeras.colorwheel_harmony.app_core.AbstractColorWheelApplication;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.colorwheel_harmony.model.ColorDetails;
import com.valeras.colorwheel_harmony.ui.ApplicationMainWindow;
import com.valeras.colorwheel_harmony.ui.swing.windows.ColorChartWindow;
import com.valeras.mdi.AbstractDocumentManager;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorCombineToolkitObserver {
    private static boolean updatingDocument = false;
    private static boolean ignoreDocument = false;
    private final AbstractColorCombineToolkit colorCombineToolkit;
    private AbstractDocumentManager<AbstractColorDocument> documentManager;
    private final ChangeListener colorPaletteChangeListener;
    private final ItemListener colorPaletteItemListener;
    private ColorWheelController colorWheelController;
    private final ChangeListener colorWheelChangeListener;
    private final ChangeListener colorMatchingChangeListener;

    public ColorCombineToolkitObserver(AbstractColorCombineToolkit colorCombineToolkit) {
        this.colorCombineToolkit = colorCombineToolkit;
        this.colorWheelController = null;
        this.colorPaletteChangeListener = new DefaultColorPaletteChangeListener();
        this.colorPaletteItemListener = new DefaultColorPaletteItemListener();
        this.colorWheelChangeListener = new DefaultColorWheelChangeListener();
        this.colorMatchingChangeListener = new DefaultColorMatchingChangeListener();
        this.colorCombineToolkit.addColorPaletteChangeListener(this.colorPaletteChangeListener);
        this.colorCombineToolkit.addColorPaletteItemListener(this.colorPaletteItemListener);
        this.colorCombineToolkit.addColorMatchingChangeListener(this.colorMatchingChangeListener);
    }

    public void setDocumentManager(AbstractDocumentManager<AbstractColorDocument> documentManager) {
        this.documentManager = documentManager;
    }

    public void setColorWheelController(ColorWheelController colorWheelController) {
        if (this.colorWheelController != null) {
            this.colorWheelController.removeRotateChangeListener(this.colorWheelChangeListener);
        }
        this.colorWheelController = colorWheelController;
        this.colorWheelController.addRotateChangeListener(this.colorWheelChangeListener);
    }

    public static boolean isUpdatingDocument() {
        return updatingDocument;
    }

    public static void setIgnoreDocument(boolean ignore) {
        ignoreDocument = ignore;
    }

    private class DefaultColorMatchingChangeListener
    implements ChangeListener {
        private DefaultColorMatchingChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ApplicationMainWindow l_mainWindow;
            ColorSpace l_colorSpace = ColorCombineToolkitObserver.this.colorCombineToolkit.getColorMatchingColorSpace();
            ColorChart l_colorChart = l_colorSpace instanceof ColorChart ? (ColorChart)l_colorSpace : null;
            AbstractColorWheelApplication application = (AbstractColorWheelApplication)AbstractColorWheelApplication.getInstance();
            if (application != null && (l_mainWindow = application.getMainWindow()) != null) {
                ColorChartWindow l_window = l_mainWindow.getColorChartWindow();
                l_window.setMatchingColorChart(l_colorChart);
            }
        }
    }

    private class DefaultColorWheelChangeListener
    implements ChangeListener {
        private DefaultColorWheelChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractColorDocument l_document = (AbstractColorDocument)ColorCombineToolkitObserver.this.documentManager.getSelectedDocument();
            if (l_document != null) {
                l_document.setColorWheelIndex0(((ColorWheel)ColorCombineToolkitObserver.this.colorWheelController.getModel()).getIndex0());
            }
        }
    }

    private class DefaultColorPaletteItemListener
    implements ItemListener {
        private DefaultColorPaletteItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            AbstractColorWheelApplication application = (AbstractColorWheelApplication)AbstractColorWheelApplication.getInstance();
            if (e.getStateChange() == 1) {
                ApplicationMainWindow l_mainWindow;
                Color l_color = ColorCombineToolkitObserver.this.colorCombineToolkit.getSelectedColor();
                if (application != null && (l_mainWindow = application.getMainWindow()) != null) {
                    l_mainWindow.getColorWheelComponent().setSelectedColor(l_color);
                    ColorChartWindow l_colorChartWindow = l_mainWindow.getColorChartWindow();
                    if (l_colorChartWindow != null) {
                        l_colorChartWindow.setSelectedColor(l_color);
                    }
                }
            }
        }
    }

    private class DefaultColorPaletteChangeListener
    implements ChangeListener {
        private DefaultColorPaletteChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ApplicationMainWindow l_mainWindow;
            AbstractColorWheelApplication application;
            ColorPalette l_colorPalette = ColorCombineToolkitObserver.this.colorCombineToolkit.getColorPalette();
            AbstractColorDocument l_document = (AbstractColorDocument)ColorCombineToolkitObserver.this.documentManager.getSelectedDocument();
            if (l_document != null && !ignoreDocument) {
                updatingDocument = true;
                l_document.setColorPalette(l_colorPalette);
                updatingDocument = false;
            }
            if ((application = (AbstractColorWheelApplication)AbstractColorWheelApplication.getInstance()) != null && (l_mainWindow = application.getMainWindow()) != null) {
                Color l_color = ColorCombineToolkitObserver.this.colorCombineToolkit.getSelectedColor();
                l_mainWindow.getColorWheelComponent().setSampleColors(l_colorPalette.getColors());
                l_mainWindow.getColorWheelComponent().setSelectedColor(l_color);
                ColorChartWindow l_colorChartWindow = l_mainWindow.getColorChartWindow();
                if (l_colorChartWindow != null) {
                    l_colorChartWindow.setSelectedColor(l_color);
                }
            }
            ColorDetails.optimizeCache(l_colorPalette.getColors());
        }
    }
}

