/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.model;

import com.valeras.color_combine.AbstractColorCombineToolkit;
import com.valeras.color_combine.cms.ColorMatchingSystem;
import com.valeras.color_combine.model.ColorPalette;
import com.valeras.color_combine.model.ColorProducer;
import com.valeras.color_combine.model.ColorScheme;
import com.valeras.color_combine.model.ColorSpectrum;
import com.valeras.color_combine.model.ColorTuner;
import com.valeras.color_combine.model.ColorWheel;
import com.valeras.color_combine.model.GrayscaleColorTuner;
import com.valeras.color_combine.model.VariateColorTuner;
import com.valeras.color_combine.model.color_schemes.AnalogousColorScheme;
import com.valeras.color_combine.model.color_schemes.ComplementaryColorScheme;
import com.valeras.color_combine.model.color_schemes.DoubleComplementaryColorScheme;
import com.valeras.color_combine.model.color_schemes.MonochromaticColorScheme;
import com.valeras.color_combine.model.color_schemes.SplitComplementaryColorScheme;
import com.valeras.color_combine.model.color_schemes.TriadicColorScheme;
import com.valeras.color_combine.model.color_tuners.Default3X3VariateColorTuner;
import com.valeras.color_combine.model.color_tuners.DefaultColorWheelVariateColorTuner;
import com.valeras.color_combine.model.color_tuners.GrayscaleVariateColorTuner;
import com.valeras.color_combine.view.ColorPaletteView;
import com.valeras.color_combine.view.ColorProducerView;
import com.valeras.color_combine.view.ColorTunerView;
import com.valeras.color_combine.view.ColorWheelView;
import com.valeras.color_combine.view.GrayscaleColorTunerView;
import com.valeras.color_combine.view.VariateColorTunerView;
import com.valeras.colorwheel_harmony.app_core.ApplicationSettings;
import com.valeras.colorwheel_harmony.app_core.ApplicationView;
import com.valeras.colorwheel_harmony.model.ColorSpaceProvider;
import com.valeras.colorwheel_harmony.model.RYBColors;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorCombineToolkit
extends AbstractColorCombineToolkit {
    private static final int DEFAULT_PALETTE_SIZE = 8;
    private static final int SECTOR_COUNT = 12;
    private ApplicationView view;
    private ColorPalette colorPalette = new ColorPalette(8);
    private final ColorWheel colorWheel = new ColorWheel(new ColorSpectrum(RYBColors.DEFAULT_SPECTRUM, RYBColors.COLOR_NAMES, (VariateColorTuner)new DefaultColorWheelVariateColorTuner()));
    private final Default3X3VariateColorTuner variateTuner = new Default3X3VariateColorTuner();
    private final GrayscaleVariateColorTuner grayscaleTuner = new GrayscaleVariateColorTuner();
    private BufferedImage image = null;
    private Object imageSource = null;
    private final ArrayList<ChangeListener> imageChangeListeners = new ArrayList();
    private final ChangeEvent imageChangeEvent = new ChangeEvent((Object)this);

    public ColorCombineToolkit() {
        this.addColorSampleProducer((ColorProducer)this.colorWheel);
        this.addColorScheme((ColorScheme)new MonochromaticColorScheme(12));
        this.addColorScheme((ColorScheme)new ComplementaryColorScheme(12));
        this.addColorScheme((ColorScheme)new SplitComplementaryColorScheme(12));
        this.addColorScheme((ColorScheme)new DoubleComplementaryColorScheme(12));
        this.addColorScheme((ColorScheme)new AnalogousColorScheme(12));
        this.addColorScheme((ColorScheme)new TriadicColorScheme(12));
        this.addColorTuner((ColorTuner)this.variateTuner);
        this.addColorTuner((ColorTuner)this.grayscaleTuner);
        this.setColorMatchingSystem(new ColorMatchingSystem(null));
    }

    public void modelInit(ApplicationSettings settings) {
        ColorSpaceProvider l_csp = ColorSpaceProvider.getInstance();
        ColorSpace l_cs = null;
        l_csp.setCMYKProfile(settings.getCMYKProfile());
        String l_csName = settings.getMatchingColorSystem();
        if (l_csName != null) {
            l_cs = l_csp.provide(l_csName);
        }
        this.toolkitInit(this.colorPalette, "color_wheel", settings.getColorScheme(), "color_tuner.3x3_variate;color_tuner.grayscale_variate");
        if (l_cs != null) {
            this.setColorMatchingColorSpace(l_cs);
        }
    }

    public void setView(ApplicationView view) {
        this.view = view;
    }

    public void setImage(BufferedImage image, Object source) {
        this.image = image;
        this.imageSource = source;
        this.fireImageChangeEvent();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Object getImageSource() {
        return this.imageSource;
    }

    public void addImageChangeListener(ChangeListener l) {
        this.imageChangeListeners.add(l);
    }

    public void removeImageChangeListener(ChangeListener l) {
        this.imageChangeListeners.remove(l);
    }

    protected void fireImageChangeEvent() {
        for (ChangeListener l : this.imageChangeListeners) {
            l.stateChanged(this.imageChangeEvent);
        }
    }

    public ColorProducerView attachView(ColorProducer colorSampleProducerModel) {
        ColorWheelView l_view = null;
        if (colorSampleProducerModel instanceof ColorWheel) {
            ColorWheelView l_colorWheelView;
            l_view = l_colorWheelView = this.view.getColorWheelView();
            l_colorWheelView.setModel((ColorWheel)colorSampleProducerModel);
        }
        return l_view;
    }

    public ColorPaletteView attachView(ColorPalette colorPalleteModel) {
        ColorPaletteView l_view = this.view.getColorPaletteView();
        l_view.setModel(this.colorPalette);
        return l_view;
    }

    public ColorTunerView attachView(ColorTuner colorTunerModel) {
        GrayscaleColorTunerView l_view = null;
        String l_modelName = colorTunerModel.getName();
        if (l_modelName.equals(this.grayscaleTuner.getName())) {
            GrayscaleColorTunerView l_grayscaleView;
            l_view = l_grayscaleView = this.view.getGrayscaleColorTunerView();
            l_grayscaleView.setModel((GrayscaleColorTuner)colorTunerModel);
        } else if (l_modelName.equals(this.variateTuner.getName())) {
            VariateColorTunerView l_variateView = this.view.getVariateColorTunerView();
            l_view = l_variateView;
            l_variateView.setModel((VariateColorTuner)colorTunerModel);
        }
        return l_view;
    }
}

