/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.model;

import com.valeras.color_chart.ColorChart;
import com.valeras.color_chart.reader.ColorChartReader;
import com.valeras.color_chart.reader.acb_acad.ACB_PaletteReader;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.crayola_crayon_colors.CrayolaCrayonColors;
import com.valeras.html_colors.HTMLColors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class ColorChartManager {
    private static final String STR_ACB_EXTENSION = "acb";
    private static final String STR_ACB_DESCRIPTION = "color_chart_manager.acb_description";
    private static final int POOL_CAPACITY = 1;
    private final ArrayList<ColorChart> colorCharts = new ArrayList();
    private final ArrayList<ColorChart> pool = new ArrayList();
    private final HashMap<String, ColorChart> index = new HashMap();
    private final ArrayList<ReaderTag> readerList = new ArrayList();
    private final int poolCapacity;
    private boolean usePool = false;

    public ColorChartManager() {
        this.poolCapacity = 1;
        this.readerList.add(new ReaderTag(STR_ACB_EXTENSION, StringTable.get(STR_ACB_DESCRIPTION), (ColorChartReader)new ACB_PaletteReader()));
        this.addColorChart((ColorChart)HTMLColors.getInstance());
        this.addColorChart((ColorChart)CrayolaCrayonColors.getInstance());
        this.beginPool();
    }

    public int getPoolCapacity() {
        return this.poolCapacity;
    }

    public final void beginPool() {
        this.usePool = true;
    }

    public Collection<ColorChart> getColorCharts() {
        ArrayList<ColorChart> l_charts = new ArrayList<ColorChart>();
        l_charts.addAll(this.colorCharts);
        l_charts.addAll(this.pool);
        return l_charts;
    }

    public final int addColorChart(ColorChart colorChart) {
        if (this.usePool) {
            if (this.pool.size() >= this.poolCapacity) {
                this.pool.set(this.pool.size() - 1, colorChart);
            } else {
                this.pool.add(colorChart);
            }
        } else {
            this.colorCharts.add(colorChart);
        }
        this.index.put(colorChart.getName(), colorChart);
        return 0;
    }

    public ColorChart getColorChart(String name) {
        return this.index.get(name);
    }

    public ColorChart getColorChart(int index) {
        return this.pool.get(index);
    }

    public Collection<ReaderTag> getReaderList() {
        return Collections.unmodifiableCollection(this.readerList);
    }

    public ColorChart createColorChart() {
        return new ColorChart();
    }

    public static class ReaderTag {
        private final String extension;
        private final String description;
        private final ColorChartReader reader;

        public ReaderTag(String fileExtension, String description, ColorChartReader reader) {
            this.extension = fileExtension;
            this.description = description;
            this.reader = reader;
        }

        public String getFileExtension() {
            return this.extension;
        }

        public String getFormatDescription() {
            return this.description;
        }

        public ColorChartReader getReader() {
            return this.reader;
        }
    }
}

