/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.document.io.txt_paint_net;

import com.valeras.color_combine.model.ColorPalette;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.colorwheel_harmony.document.io.txt_paint_net.TXTColorPaletteEntry;
import com.valeras.colorwheel_harmony.document.io.txt_paint_net.TXTColorPaletteEntryFormat;
import com.valeras.colorwheel_harmony.document.io.txt_paint_net.TXTConstants;
import com.valeras.mdi.AbstractDocument;
import com.valeras.mdi.DocumentWriter;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class TXTWriter
implements DocumentWriter,
TXTConstants {
    private static final String NAME = "colorwheel_harmony.document_writer.paint_net.txt";
    private static final String STR_HEADER = "; Paint.NET Palette File";
    private static final String VERSION = "A";
    private static final int REVISION = 0;
    private final TXTColorPaletteEntryFormat paletteFormat = new TXTColorPaletteEntryFormat();

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public int getRevision() {
        return 0;
    }

    public void write(AbstractDocument document, OutputStream stream) throws IOException {
        ColorPalette l_palette = ((AbstractColorDocument)document).getColorPalette();
        String l_buffer = "; Paint.NET Palette File\n";
        for (int i = 0; i < l_palette.size(); ++i) {
            Color l_color = (Color)l_palette.get(i);
            if (l_color == null) continue;
            l_buffer = l_buffer + this.paletteFormat.format(new TXTColorPaletteEntry(l_color)) + "\n";
        }
        BufferedWriter l_bw = new BufferedWriter(new OutputStreamWriter(stream));
        l_bw.write(l_buffer);
        l_bw.close();
    }

    public String toString() {
        return "colorwheel_harmony.document_writer.paint_net.txt version='A' revision=0";
    }
}

