/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.document.io.txt_paint_net;

import com.valeras.color_combine.model.ColorPalette;
import com.valeras.colorwheel_harmony.document.io.txt_paint_net.PaintNETPaletteFile;
import com.valeras.colorwheel_harmony.document.io.txt_paint_net.TXTColorPaletteEntry;
import com.valeras.colorwheel_harmony.document.io.txt_paint_net.TXTColorPaletteEntryFormat;
import com.valeras.colorwheel_harmony.document.io.txt_paint_net.TXTConstants;
import com.valeras.mdi.AbstractDocument;
import com.valeras.mdi.DocumentReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;

public class TXTReader
implements DocumentReader,
TXTConstants {
    private static final String NAME = "colorwheel_harmony.document_reader.paint_net.txt";
    private static final String VERSION = "A";
    private static final int REVISION = 0;
    private final TXTColorPaletteEntryFormat paletteFormat = new TXTColorPaletteEntryFormat();

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public int getRevision() {
        return 0;
    }

    public void read(InputStream stream, AbstractDocument document) throws IOException, ParseException {
        String l_text;
        PaintNETPaletteFile l_document = (PaintNETPaletteFile)document;
        ColorPalette l_palette = new ColorPalette();
        BufferedReader l_br = new BufferedReader(new InputStreamReader(stream));
        while ((l_text = l_br.readLine()) != null) {
            TXTColorPaletteEntry l_entry;
            if ((l_text = l_text.trim()).isEmpty() || l_text.startsWith(";")) continue;
            try {
                l_entry = (TXTColorPaletteEntry)this.paletteFormat.parseObject(l_text);
            }
            catch (ParseException ex) {
                continue;
            }
            l_palette.add((Object)l_entry.getColor());
        }
        if (l_palette.size() < 1) {
            throw new ParseException(l_text, 0);
        }
        l_document.setColorPalette(l_palette);
        l_br.close();
    }

    public String toString() {
        return "colorwheel_harmony.document_reader.paint_net.txt version='A' revision=0";
    }
}

