/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.document.io.txt_paint_net;

import com.valeras.colorwheel_harmony.document.io.txt_paint_net.TXTColorPaletteEntry;
import java.awt.Color;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;

class TXTColorPaletteEntryFormat
extends Format {
    public static final String NAME = "format.color_palette_entry.paint_net_txt";
    private static final String FORMAT_PATTERN = "FF{0}";

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        TXTColorPaletteEntry l_entry = (TXTColorPaletteEntry)obj;
        Color l_color = l_entry.getColor();
        String l_text = MessageFormat.format(FORMAT_PATTERN, TXTColorPaletteEntryFormat.formatRGB(l_color.getRGB()));
        toAppendTo.append(l_text);
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        int l_rgb;
        String l_str = source.substring(pos.getIndex());
        try {
            l_rgb = (int)(Long.parseLong(l_str, 16) & 0xFFFFFFL);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        TXTColorPaletteEntry l_entry = new TXTColorPaletteEntry(new Color(l_rgb));
        pos.setIndex(source.length() - 1);
        return l_entry;
    }

    private static String formatRGB(int rgb) {
        String l_text = "";
        String l_rgb = Integer.toHexString(rgb & 0xFFFFFF);
        int l_count = l_rgb.length();
        if (l_count < 6) {
            l_count = 6 - l_count;
            for (int i = 0; i < l_count; ++i) {
                l_text = l_text + "0";
            }
        }
        l_text = l_text + l_rgb;
        return l_text.toUpperCase();
    }
}

