/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.document.io.gpl_gimp;

import com.valeras.color_combine.model.ColorPalette;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.colorwheel_harmony.document.io.gpl_gimp.GPLColorPaletteEntry;
import com.valeras.colorwheel_harmony.document.io.gpl_gimp.GPLColorPaletteEntryFormat;
import com.valeras.colorwheel_harmony.document.io.gpl_gimp.GPLConstants;
import com.valeras.colorwheel_harmony.model.ColorDetails;
import com.valeras.mdi.AbstractDocument;
import com.valeras.mdi.DocumentWriter;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;

public class GPLWriter
implements DocumentWriter,
GPLConstants {
    private static final String NAME = "colorwheel_harmony.document_writer.gimp.gpl";
    private static final String VERSION = "A";
    private static final int REVISION = 0;
    private final GPLColorPaletteEntryFormat paletteFormat = new GPLColorPaletteEntryFormat();

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public int getRevision() {
        return 0;
    }

    public void write(AbstractDocument document, OutputStream stream) throws IOException {
        String l_buffer = "GIMP Palette\n";
        ColorPalette l_palette = ((AbstractColorDocument)document).getColorPalette();
        int l_columns = 4;
        l_buffer = l_buffer + MessageFormat.format("Name: {0}", document.getName()) + "\n";
        l_buffer = l_buffer + MessageFormat.format("Columns: {0}", Integer.toString(4)) + "\n";
        l_buffer = l_buffer + "#\n";
        for (int i = 0; i < l_palette.size(); ++i) {
            Color l_color = (Color)l_palette.get(i);
            if (l_color == null) continue;
            String l_label = l_palette.getLabel(i);
            if (l_label == null) {
                ColorDetails l_details = ColorDetails.getDetails(l_color);
                l_label = l_details.getDetailedName();
            }
            GPLColorPaletteEntry l_entry = new GPLColorPaletteEntry(l_color, l_label);
            l_buffer = l_buffer + this.paletteFormat.format(l_entry) + "\n";
        }
        BufferedWriter l_bw = new BufferedWriter(new OutputStreamWriter(stream));
        l_bw.write(l_buffer);
        l_bw.close();
    }

    public String toString() {
        return "colorwheel_harmony.document_writer.gimp.gpl version='A' revision=0";
    }
}

