/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.document.io.gpl_gimp;

import com.valeras.color_combine.model.ColorPalette;
import com.valeras.colorwheel_harmony.document.io.gpl_gimp.GIMPPaletteFile;
import com.valeras.colorwheel_harmony.document.io.gpl_gimp.GPLColorPaletteEntry;
import com.valeras.colorwheel_harmony.document.io.gpl_gimp.GPLColorPaletteEntryFormat;
import com.valeras.colorwheel_harmony.document.io.gpl_gimp.GPLConstants;
import com.valeras.mdi.AbstractDocument;
import com.valeras.mdi.DocumentReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;

public class GPLReader
implements DocumentReader,
GPLConstants {
    private static final String NAME = "colorwheel_harmony.document_reader.gimp.gpl";
    private static final String VERSION = "A";
    private static final int REVISION = 0;
    private final GPLColorPaletteEntryFormat paletteFormat = new GPLColorPaletteEntryFormat();

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public int getRevision() {
        return 0;
    }

    public void read(InputStream stream, AbstractDocument document) throws IOException, ParseException {
        String l_text;
        GIMPPaletteFile l_document = (GIMPPaletteFile)document;
        ColorPalette l_palette = new ColorPalette();
        String l_signature = null;
        boolean l_gplSignature = false;
        String l_gplName = null;
        int l_gplColumns = 0;
        boolean l_colors = false;
        BufferedReader l_br = new BufferedReader(new InputStreamReader(stream));
        while ((l_text = l_br.readLine()) != null) {
            l_text = l_text.trim();
            if (l_signature == null) {
                l_signature = l_text;
            }
            if (l_colors) {
                GPLColorPaletteEntry l_entry = (GPLColorPaletteEntry)this.paletteFormat.parseObject(l_text);
                l_palette.add((Object)l_entry.getColor());
                l_palette.setLabel(l_palette.size() - 1, l_entry.getText());
                continue;
            }
            if (l_text.equalsIgnoreCase("GIMP Palette")) {
                l_gplSignature = true;
                continue;
            }
            if (l_text.startsWith("Name:")) {
                l_gplName = l_text.substring("Name:".length()).trim();
                continue;
            }
            if (l_text.startsWith("Columns:")) {
                l_gplColumns = Integer.parseInt(l_text.substring("Columns:".length()).trim());
                continue;
            }
            if (!l_text.equals("#")) continue;
            l_colors = true;
        }
        if (!l_gplSignature) {
            throw new ParseException(l_signature, 0);
        }
        document.setName(l_gplName);
        l_document.setColorPalette(l_palette);
        l_br.close();
    }

    public String toString() {
        return "colorwheel_harmony.document_reader.gimp.gpl version='A' revision=0";
    }
}

