/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.document.io.gpl_gimp;

import com.valeras.colorwheel_harmony.document.io.gpl_gimp.GPLColorPaletteEntry;
import java.awt.Color;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.StringTokenizer;

class GPLColorPaletteEntryFormat
extends Format {
    public static final String NAME = "format.color_palette_entry.gpl";
    private static final String FORMAT_PATTERN = "{0} {1} {2}\t{3}";

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        GPLColorPaletteEntry l_entry = (GPLColorPaletteEntry)obj;
        int[] l_rgb = l_entry.getColorComponents();
        String l_label = l_entry.getText();
        String l_text = MessageFormat.format(FORMAT_PATTERN, new Integer(l_rgb[0]), new Integer(l_rgb[1]), new Integer(l_rgb[2]), GPLColorPaletteEntryFormat.supressNull(l_label));
        toAppendTo.append(l_text);
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        int l_blue;
        int l_green;
        int l_red;
        String l_text;
        int l_index = 0;
        String l_label = null;
        String l_str = source.substring(pos.getIndex());
        int l_tabPos = l_str.indexOf("\t");
        if (l_tabPos > 0) {
            l_text = l_str.substring(0, l_tabPos);
            l_label = l_str.substring(l_tabPos + 1).trim();
        } else {
            l_text = l_str;
        }
        StringTokenizer l_st = new StringTokenizer(l_text, " ");
        String[] l_tokens = new String[l_st.countTokens()];
        while (l_st.hasMoreTokens()) {
            l_tokens[l_index++] = l_st.nextToken().trim();
        }
        try {
            l_red = Integer.parseInt(l_tokens[0]);
            l_green = Integer.parseInt(l_tokens[1]);
            l_blue = Integer.parseInt(l_tokens[2]);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        if (l_index > 4) {
            l_label = l_tokens[3];
        }
        GPLColorPaletteEntry l_entry = new GPLColorPaletteEntry(new Color(l_red, l_green, l_blue), l_label);
        pos.setIndex(source.length() - 1);
        return l_entry;
    }

    private static String supressNull(String value) {
        return value != null ? value : "";
    }
}

