/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.document.io.chp;

import com.valeras.color_chart.io.format.FloatArrayFormat;
import com.valeras.colorwheel_harmony.document.io.chp.ColorPaletteEntry;
import com.valeras.colorwheel_harmony.model.ColorCoding;
import com.valeras.colorwheel_harmony.model.ColorProducer;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

class ColorPaletteEntryFormat
extends Format {
    public static final String NAME = "format.color_palette_entry";
    protected static final String OP_DELIMITER = ";";
    protected static final String OP_ASSIGN = "=";
    protected static final String ATTR_SYSTEM_CODE = "system_code";
    protected static final String ATTR_COLOR_COMPONENTS = "color_components";
    protected static final String ATTR_COLOR_SPACE = "color_space";
    protected static final String ATTR_RGB = "rgb";
    protected static final String ATTR_LABEL = "label";
    private final FloatArrayFormat floatArrayFormat = new FloatArrayFormat();

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        ColorPaletteEntry l_entry = (ColorPaletteEntry)obj;
        String l_str = "";
        String l_codeStr = "";
        String l_rgbStr = "";
        String l_csStr = "";
        String l_componentsStr = "";
        Color l_color = l_entry.getColor();
        String l_labelStr = l_entry.getText();
        if (l_color != null) {
            float[] l_colorComponents;
            l_codeStr = l_entry.getCode();
            l_csStr = l_entry.getColorSpaceName();
            l_rgbStr = ColorCoding.formatRGB(l_color.getRGB());
            ColorSpace l_cs = l_color.getColorSpace();
            float[] fArray = l_colorComponents = l_cs != null ? l_color.getColorComponents(l_cs, null) : l_color.getColorComponents(null);
            if (l_colorComponents != null) {
                l_componentsStr = this.floatArrayFormat.format((Object)l_colorComponents);
            }
        }
        l_str = l_str + "rgb=" + l_rgbStr;
        l_str = l_str + ";color_space=" + ColorPaletteEntryFormat.supressNull(l_csStr);
        l_str = l_str + ";color_components=" + ColorPaletteEntryFormat.supressNull(l_componentsStr);
        l_str = l_str + ";system_code=" + ColorPaletteEntryFormat.supressNull(l_codeStr);
        l_str = l_str + ";label=" + ColorPaletteEntryFormat.supressNull(l_labelStr);
        toAppendTo.append(l_str);
        return toAppendTo;
    }

    private static String supressNull(String value) {
        return value != null ? value : "";
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        Color l_entryColor = null;
        int l_attrRGB = -1;
        String l_attrColorSpaceName = null;
        String l_attrSystemCode = null;
        String l_entryLabel = null;
        float[] l_attrColorComponents = null;
        String l_str = source.substring(pos.getIndex());
        StringTokenizer l_st = new StringTokenizer(l_str, OP_DELIMITER);
        while (l_st.hasMoreTokens()) {
            String l_token = l_st.nextToken();
            String[] l_op = l_token.split(OP_ASSIGN);
            String l_key = l_op[0];
            String l_value = l_op.length >= 2 ? l_op[1] : null;
            if (l_value == null) continue;
            if (l_key.equalsIgnoreCase(ATTR_RGB)) {
                if (l_value == null) continue;
                l_attrRGB = Integer.parseInt(l_value, 16);
                continue;
            }
            if (l_key.equalsIgnoreCase(ATTR_COLOR_SPACE)) {
                l_attrColorSpaceName = l_value;
                continue;
            }
            if (l_key.equalsIgnoreCase(ATTR_COLOR_COMPONENTS)) {
                try {
                    l_attrColorComponents = (float[])this.floatArrayFormat.parseObject(l_value);
                }
                catch (ParseException ex) {
                    Logger.getLogger(ColorPaletteEntryFormat.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            if (l_key.equalsIgnoreCase(ATTR_SYSTEM_CODE)) {
                l_attrSystemCode = l_value;
                continue;
            }
            if (!l_key.equalsIgnoreCase(ATTR_LABEL)) continue;
            l_entryLabel = l_value;
        }
        l_entryColor = ColorProducer.produce(l_attrRGB, l_attrColorSpaceName, l_attrColorComponents, l_attrSystemCode);
        ColorPaletteEntry l_entry = new ColorPaletteEntry(l_entryColor, l_entryLabel);
        pos.setIndex(source.length() - 1);
        return l_entry;
    }
}

