/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.document.io.chp;

import com.valeras.colorwheel_harmony.model.ColorDetails;
import com.valeras.colorwheel_harmony.model.ColorSpaceProvider;
import java.awt.Color;
import java.awt.color.ColorSpace;

class ColorPaletteEntry {
    private final Color color;
    private final String text;
    private final ColorSpace colorSpace;
    private final ColorDetails colorDetails;

    public ColorPaletteEntry(Color color, String text) {
        this.color = color;
        this.colorSpace = color != null ? color.getColorSpace() : null;
        this.text = text;
        this.colorDetails = color != null ? ColorDetails.getDetails(color) : null;
    }

    public String getColorSpaceName() {
        return this.colorSpace != null ? ColorSpaceProvider.nameOf(this.colorSpace) : null;
    }

    public float[] getColorComponents() {
        float[] l_components = null;
        if (this.color != null) {
            l_components = this.colorSpace != null ? this.color.getColorComponents(this.colorSpace, null) : this.color.getColorComponents(null);
        }
        return l_components;
    }

    public Color getColor() {
        return this.color;
    }

    public String getCode() {
        return this.colorDetails != null ? this.colorDetails.getCode() : null;
    }

    public String getText() {
        return this.text;
    }
}

