/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.document.io.chp;

import com.valeras.color_combine.model.ColorPalette;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.colorwheel_harmony.document.io.chp.CHPConstants;
import com.valeras.colorwheel_harmony.document.io.chp.ColorPaletteEntry;
import com.valeras.colorwheel_harmony.document.io.chp.ColorPaletteEntryFormat;
import com.valeras.colorwheel_harmony.document.io.chp.ColorWheelProperties;
import com.valeras.colorwheel_harmony.document.io.chp.ColorWheelPropertiesFormat;
import com.valeras.mdi.AbstractDocument;
import com.valeras.mdi.DocumentWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class CHPWriter
implements DocumentWriter,
CHPConstants {
    private static final String NAME = "colorwheel_harmony.document_writer.chp";
    private static final String VERSION = "A";
    private static final int REVISION = 0;

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public int getRevision() {
        return 0;
    }

    public void write(AbstractDocument document, OutputStream stream) throws IOException {
        Properties l_properties = new Properties();
        ColorPaletteEntryFormat l_format = new ColorPaletteEntryFormat();
        AbstractColorDocument l_document = (AbstractColorDocument)document;
        ColorWheelPropertiesFormat l_colorWheelFormat = new ColorWheelPropertiesFormat();
        String l_colorScheme = l_document.getColorScheme();
        String l_paletteLayout = l_document.getPaletteLayout();
        ColorWheelProperties l_colorWheel = new ColorWheelProperties(l_document.getColorWheelModel(), l_document.getColorWheelIndex0());
        l_properties.setProperty("document_name", document.getName());
        l_properties.setProperty("document_revision", String.valueOf(document.getRevision()));
        l_properties.setProperty("color_wheel", l_colorWheelFormat.format(l_colorWheel));
        if (l_colorScheme != null) {
            l_properties.setProperty("color_scheme", l_colorScheme);
        }
        if (l_paletteLayout != null) {
            l_properties.setProperty("palette_layout", l_paletteLayout);
        }
        ColorPalette l_colorPalette = l_document.getColorPalette();
        int l_colorNum = l_colorPalette.size();
        for (int i = 0; i < l_colorNum; ++i) {
            ColorPaletteEntry l_entry = new ColorPaletteEntry((Color)l_colorPalette.get(i), l_colorPalette.getLabel(i));
            String l_entryKey = "color_palette_entry_n" + Integer.toString(i);
            String l_entryValue = l_format.format(l_entry);
            l_properties.setProperty(l_entryKey, l_entryValue);
        }
        l_properties.store(stream, this.toString());
    }

    public String toString() {
        return "colorwheel_harmony.document_writer.chp version='A' revision=0";
    }
}

