/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.document.io.chp;

import com.valeras.color_combine.model.ColorPalette;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.colorwheel_harmony.document.io.chp.CHPConstants;
import com.valeras.colorwheel_harmony.document.io.chp.ColorPaletteEntry;
import com.valeras.colorwheel_harmony.document.io.chp.ColorPaletteEntryFormat;
import com.valeras.colorwheel_harmony.document.io.chp.ColorWheelProperties;
import com.valeras.colorwheel_harmony.document.io.chp.ColorWheelPropertiesFormat;
import com.valeras.mdi.AbstractDocument;
import com.valeras.mdi.DocumentReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class CHPReader
implements DocumentReader,
CHPConstants {
    private static final String NAME = "colorwheel_harmony.document_reader.chp";
    private static final String VERSION = "A";
    private static final int REVISION = 0;

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public int getRevision() {
        return 0;
    }

    public void read(InputStream stream, AbstractDocument document) throws IOException, ParseException {
        ColorWheelProperties l_colorWheelProperties;
        Properties l_properties = new Properties();
        ColorPaletteEntryFormat l_paletteEntryFormat = new ColorPaletteEntryFormat();
        ColorWheelPropertiesFormat l_colorWheelFormat = new ColorWheelPropertiesFormat();
        AbstractColorDocument l_document = (AbstractColorDocument)document;
        HashMap<Integer, String> l_colorKeys = new HashMap<Integer, String>();
        int l_maxIndex = 0;
        l_properties.load(stream);
        Set<String> l_keys = l_properties.stringPropertyNames();
        String l_value = l_properties.getProperty("document_name");
        if (l_value != null) {
            document.setName(l_value);
        }
        if ((l_value = l_properties.getProperty("document_revision")) != null) {
            document.setRevision(Integer.valueOf(l_value));
        }
        if ((l_value = l_properties.getProperty("color_scheme")) != null) {
            l_document.setColorScheme(l_value);
        }
        if ((l_value = l_properties.getProperty("palette_layout")) != null) {
            l_document.setPaletteLayout(l_value);
        }
        if ((l_value = l_properties.getProperty("color_wheel")) != null && (l_colorWheelProperties = (ColorWheelProperties)l_colorWheelFormat.parseObject(l_value)) != null) {
            l_document.setColorWheelIndex0(l_colorWheelProperties.getIndex0());
        }
        for (String k : l_keys) {
            if (!k.toLowerCase().startsWith("color_palette_entry_n")) continue;
            l_value = k.substring("color_palette_entry_n".length());
            int l_index = Integer.valueOf(l_value);
            if (l_index > l_maxIndex) {
                l_maxIndex = l_index;
            }
            l_colorKeys.put(new Integer(l_index), k);
        }
        ColorPalette l_colorPalette = new ColorPalette(l_maxIndex + 1);
        for (int i = 0; i <= l_maxIndex; ++i) {
            l_value = (String)l_colorKeys.get(new Integer(i));
            if ((l_value = l_properties.getProperty(l_value)) == null) continue;
            ColorPaletteEntry l_entry = (ColorPaletteEntry)l_paletteEntryFormat.parseObject(l_value);
            l_colorPalette.set(i, (Object)l_entry.getColor());
            l_colorPalette.setLabel(i, l_entry.getText());
        }
        l_document.setColorPalette(l_colorPalette);
    }

    public String toString() {
        return "colorwheel_harmony.document_reader.chp version='A' revision=0";
    }
}

