/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.document;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.actions.SelectColorSchemeAction;
import com.valeras.colorwheel_harmony.actions.ViewSelectPaletteLayoutAction;
import com.valeras.colorwheel_harmony.app_core.AbstractColorWheelApplication;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.colorwheel_harmony.document.io.chp.CHPDocument;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkitObserver;
import com.valeras.mdi.AbstractDocument;
import com.valeras.mdi.event.DocumentManagerEvent;
import com.valeras.mdi.event.DocumentManagerListener;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenuItem;

public class DefaultDocumentManagerListener
implements DocumentManagerListener {
    protected final AbstractColorWheelApplication application;
    private final ColorCombineToolkit toolkit;
    private final DefaultDocumentListener documentListener;

    public DefaultDocumentManagerListener(AbstractColorWheelApplication application) {
        this.application = application;
        this.toolkit = application.getColorCombineToolkit();
        this.documentListener = new DefaultDocumentListener();
    }

    @Override
    public void documentOpened(DocumentManagerEvent event) {
    }

    @Override
    public void documentClosed(DocumentManagerEvent event) {
    }

    @Override
    public void documentSelected(DocumentManagerEvent event) {
        AbstractColorDocument l_document = (AbstractColorDocument)event.getDocument();
        ActionEvent l_defaultActionEvent = new ActionEvent(this, 0, "");
        String l_colorScheme = l_document.getColorScheme();
        String l_paletteLayout = l_document.getPaletteLayout();
        int l_index0 = l_document.getColorWheelIndex0();
        this.updateWindowTitle(l_document);
        if (l_colorScheme != null) {
            new SelectColorSchemeAction(l_colorScheme).actionPerformed(l_defaultActionEvent);
        }
        if (l_paletteLayout != null) {
            String l_command = ViewSelectPaletteLayoutAction.commandName(l_paletteLayout);
            AbstractApplicationAction l_action = this.application.getAction(l_command);
            JMenuItem l_menuItem = this.application.getMenuItem(l_command);
            if (l_action != null) {
                l_action.actionPerformed(l_defaultActionEvent);
            }
            if (l_menuItem != null) {
                l_menuItem.setSelected(true);
            }
        }
        this.application.getMainWindow().getColorWheelView().getModel().setIndex0(l_index0);
        AbstractApplicationAction l_action = this.application.getAction("action.file.import");
        if (l_action != null) {
            l_action.setEnabled(l_document instanceof CHPDocument);
        }
        ColorCombineToolkitObserver.setIgnoreDocument(true);
        this.toolkit.updateColorPalette(l_document.getColorPalette());
        ColorCombineToolkitObserver.setIgnoreDocument(false);
        l_document.addPropertyChangeListener(this.documentListener);
    }

    @Override
    public void documentDeselected(DocumentManagerEvent event) {
        AbstractColorDocument l_document = (AbstractColorDocument)event.getDocument();
        l_document.removePropertyChangeListener(this.documentListener);
        this.application.getMainWindow().setTitle(this.application.getTitle());
    }

    @Override
    public void documentUpdate(DocumentManagerEvent event) {
    }

    @Override
    public void documentChanged(DocumentManagerEvent event) {
        this.updateWindowTitle(event.getDocument());
    }

    private void updateWindowTitle(AbstractDocument document) {
        String l_text = document.getName() + (document.isChanged() ? "*" : "") + " - " + this.application.getTitle();
        this.application.getMainWindow().setTitle(l_text);
    }

    private class DefaultDocumentListener
    implements PropertyChangeListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractColorDocument l_document = (AbstractColorDocument)evt.getSource();
            String l_property = evt.getPropertyName();
            if (l_property.equalsIgnoreCase("color_palette") && !ColorCombineToolkitObserver.isUpdatingDocument()) {
                DefaultDocumentManagerListener.this.toolkit.updateColorPalette(l_document.getColorPalette());
            }
        }
    }
}

