/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.document;

import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.colorwheel_harmony.document.SupportedFileFormats;
import com.valeras.colorwheel_harmony.document.io.chp.CHPDocument;
import com.valeras.colorwheel_harmony.document.io.gpl_gimp.GIMPPaletteFile;
import com.valeras.colorwheel_harmony.document.io.txt_paint_net.PaintNETPaletteFile;
import com.valeras.colorwheel_harmony.resources.HarmonyResources;
import com.valeras.mdi.AbstractDocument;
import com.valeras.mdi.AbstractDocumentFactory;
import com.valeras.mdi.FileFormat;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ColorDocumentFactory
implements AbstractDocumentFactory {
    private static final String MSG_UNKNOWN_FORMAT = "Can't create document of the {0} type.";
    private final Properties defaults = new Properties();
    private int counter = 1;

    public ColorDocumentFactory() {
        try {
            this.defaults.load(HarmonyResources.class.getResourceAsStream("document_properties/default_document_properties.properties"));
        }
        catch (IOException ex) {
            Logger.getLogger(ColorDocumentFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public AbstractDocument createDocument(FileFormat format) {
        AbstractColorDocument l_document;
        if (format.equals(SupportedFileFormats.NATIVE_FILE_FORMAT)) {
            l_document = new CHPDocument(this.nextDocumentName(), this.defaults);
        } else if (format.equals(SupportedFileFormats.GIMP_GPL_FILE_FORMAT)) {
            l_document = new GIMPPaletteFile();
        } else if (format.equals(SupportedFileFormats.PAINTNET_TXT_FILE_FORMAT)) {
            l_document = new PaintNETPaletteFile();
        } else {
            throw new RuntimeException(MessageFormat.format(MSG_UNKNOWN_FORMAT, format));
        }
        return l_document;
    }

    protected String nextDocumentName() {
        return "Palette" + String.valueOf(this.counter++);
    }
}

