/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.document;

import com.valeras.color_combine.model.ColorPalette;
import com.valeras.mdi.AbstractDocument;
import java.beans.PropertyChangeEvent;
import java.util.Properties;
import java.util.Set;

public abstract class AbstractColorDocument
extends AbstractDocument {
    protected static final String PROPERTY_COLOR_PALETTE = "color_palette";
    protected static final String PROPERTY_COLOR_SCHEME = "color_scheme";
    protected static final String PROPERTY_PALETTE_LAYOUT = "palette_layout";
    protected static final String PROPERTY_COLORWHEEL_INDEX0 = "colorwheel_index0";
    protected static final String PROPERTY_COLORWHEEL_MODEL = "colorwheel_model";
    private static final int DEFAULT_PALETTE_SIZE = 8;
    protected final ColorPalette colorPalette;

    protected AbstractColorDocument(String name, Properties defaultProperties, boolean createColorPalette) {
        super(name);
        ColorPalette colorPalette = this.colorPalette = createColorPalette ? new ColorPalette(8) : null;
        if (defaultProperties != null) {
            this.setIgnoreChanges(true);
            Set<String> l_names = defaultProperties.stringPropertyNames();
            for (String n : l_names) {
                this.properties.setProperty(n, defaultProperties.getProperty(n));
            }
            this.setIgnoreChanges(false);
        }
    }

    public ColorPalette getColorPalette() {
        return this.colorPalette;
    }

    public void setColorPalette(ColorPalette colorPalette) {
        if (!this.isColorPaletteSupported()) {
            throw new RuntimeException("This document doesn't support color palette.");
        }
        this.colorPalette.setPalette(colorPalette);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_COLOR_PALETTE, null, this.colorPalette));
        this.setChanged(true);
    }

    public boolean isColorPaletteSupported() {
        return this.colorPalette != null;
    }

    public boolean isColorSchemeSupported() {
        return false;
    }

    public boolean isPalatteLayoutSupported() {
        return false;
    }

    public boolean isColorWheelSupported() {
        return false;
    }

    public String getColorScheme() {
        return this.getProperty(PROPERTY_COLOR_SCHEME);
    }

    public void setColorScheme(String name) {
        if (this.isColorSchemeSupported()) {
            this.setProperty(PROPERTY_COLOR_SCHEME, name);
        }
    }

    public String getPaletteLayout() {
        return this.getProperty(PROPERTY_PALETTE_LAYOUT);
    }

    public void setPaletteLayout(String name) {
        if (this.isPalatteLayoutSupported()) {
            this.setProperty(PROPERTY_PALETTE_LAYOUT, name);
        }
    }

    public String getColorWheelModel() {
        return this.properties.getProperty(PROPERTY_COLORWHEEL_MODEL, null);
    }

    public void setColorWheelModel(String model) {
        if (this.isColorWheelSupported()) {
            this.setProperty(PROPERTY_COLORWHEEL_MODEL, model);
        }
    }

    public int getColorWheelIndex0() {
        return Integer.valueOf(this.properties.getProperty(PROPERTY_COLORWHEEL_INDEX0, "0"));
    }

    public void setColorWheelIndex0(int index) {
        if (this.isColorWheelSupported()) {
            this.setProperty(PROPERTY_COLORWHEEL_INDEX0, Integer.toString(index));
        }
    }
}

