/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.app_core.print;

import com.valeras.app_skeleton.Application;
import com.valeras.colorwheel_harmony.app_core.AbstractColorWheelApplication;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.app_core.print.ColorPalettePrintable;
import com.valeras.mdi.AbstractDocument;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.MessageFormat;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JComponent;

public class PrintManager {
    private static final String STR_FOOTER = "print.page.text.footer";
    private static final String STR_NOTICE = "print.page.text.notice";
    private final PrinterJob printerJob = PrinterJob.getPrinterJob();
    private final PrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
    private PageFormat pageFormat;
    private static PrintManager instance = null;

    public static PrintManager getInstance() {
        if (instance == null) {
            instance = new PrintManager();
        }
        return instance;
    }

    protected PrintManager() {
        this.printRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
        this.pageFormat = this.printerJob.getPageFormat(this.printRequestAttributeSet);
    }

    public PrinterJob getPrinterJob() {
        return this.printerJob;
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.printRequestAttributeSet;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public Printable getPrintable() {
        return new ColorPalettePrintable(this.getApplication().getMainWindow().getColorPaletteComponent(), this.getPrintableCaption(), StringTable.get(STR_NOTICE));
    }

    public Printable getPrintable(JComponent component) {
        return new ColorPalettePrintable(component, this.getPrintableCaption(), StringTable.get(STR_NOTICE));
    }

    private AbstractColorWheelApplication getApplication() {
        return (AbstractColorWheelApplication)Application.getInstance();
    }

    private String getPrintableCaption() {
        AbstractColorWheelApplication l_app = (AbstractColorWheelApplication)Application.getInstance();
        Object l_doc = l_app.getDocumentManager().getSelectedDocument();
        String l_text = MessageFormat.format(StringTable.get(STR_FOOTER), l_app.getTitle(), ((AbstractDocument)l_doc).getName(), ((AbstractDocument)l_doc).getRevision());
        return l_text;
    }
}

