/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.app_core.print;

import com.valeras.colorwheel_harmony.ui.swing.AbstractApplicationIconFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ColorPalettePrintable
implements Printable {
    private final JComponent component;
    private final String text;
    private final String notice;

    public ColorPalettePrintable(JComponent component, String text, String notice) {
        this.component = component;
        this.text = text;
        this.notice = notice;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        Graphics2D l_g2 = (Graphics2D)g.create();
        int l_fontSize = 12;
        int l_font2Size = 10;
        if (page > 0) {
            return 1;
        }
        Font l_font = new Font("SansSerif", 0, 12);
        FontMetrics l_fontMetrics = l_g2.getFontMetrics(l_font);
        Dimension l_componentSize = this.component.getSize();
        int l_stampHeight = l_fontMetrics.getHeight() * 2;
        Rectangle2D.Double l_imageableBounds = new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
        double l_scale = Math.min(((RectangularShape)l_imageableBounds).getWidth() / l_componentSize.getWidth(), (((RectangularShape)l_imageableBounds).getHeight() - (double)l_stampHeight) / l_componentSize.getHeight());
        Graphics2D l_g2c = (Graphics2D)l_g2.create();
        l_g2c.translate(((RectangularShape)l_imageableBounds).getX(), ((RectangularShape)l_imageableBounds).getY());
        l_g2c.scale(l_scale, l_scale);
        this.component.print(l_g2c.create());
        l_g2c.dispose();
        int l_iconWidth = 12;
        int l_iconHeight = 12;
        int l_textGap = 2;
        Icon l_icon = AbstractApplicationIconFactory.createApplicationIcon(l_iconWidth, l_iconHeight);
        int x = (int)((RectangularShape)l_imageableBounds).getX();
        int y = (int)(((RectangularShape)l_imageableBounds).getY() + ((RectangularShape)l_imageableBounds).getHeight() - (double)l_stampHeight);
        l_g2.setColor(Color.gray);
        l_g2.drawLine(x, y, (int)((double)x + ((RectangularShape)l_imageableBounds).getWidth()), y);
        if (this.notice != null) {
            Font l_font2 = new Font("SansSerif", 2, 10);
            FontMetrics l_fontMetrics2 = l_g2.getFontMetrics(l_font2);
            l_g2.setFont(l_font2);
            l_g2.setColor(Color.gray);
            l_g2.drawString(this.notice, x + l_textGap, y - (l_fontMetrics2.getMaxDescent() + l_textGap));
        }
        l_icon.paintIcon(null, l_g2, x += l_textGap, (y += l_fontMetrics.getMaxAscent() + l_textGap) - l_iconHeight);
        if (this.text != null) {
            l_g2.setFont(l_font);
            l_g2.setColor(Color.black);
            l_g2.drawString(this.text, x += l_iconWidth + l_textGap, y);
        }
        l_g2.dispose();
        return 0;
    }
}

