/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.app_core.features;

import com.valeras.app_skeleton.AbstractFeature;
import com.valeras.app_skeleton.Application;
import com.valeras.colorwheel_harmony.app_core.AbstractColorWheelApplication;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.app_core.copy_protection.DefaultCopyProtection;
import com.valeras.colorwheel_harmony.app_core.copy_protection.license.SharewareLicense;
import com.valeras.copy_protection.CopyProtection;
import com.valeras.copy_protection.LicenseValidationPolicy;
import com.valeras.copy_protection.LicensingModel;
import com.valeras.copy_protection.PropertyStorage;
import com.valeras.copy_protection.attributes.RegistrationInfoAttribute;
import com.valeras.copy_protection.policies.ProductEvaluationPolicy;
import com.valeras.copy_protection.property_storage.PropertiesBasedStorage;
import java.io.File;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CopyProtectionFeature
extends AbstractFeature {
    public static final String FEATURE_NAME = "feature.copy_protection";
    public static final int FEATURE_ID = 11;
    private static final String FILE_NAME = "cwh_cp.dat";
    private static final String PROPERTY_USER_NAME = "user.name";
    private static final String STR_REGINFO_EVALUATION = "cp.reg_info.evaluation";
    private static final String STR_REGINFO_SHAREWARE = "cp.reg_info.shareware";
    private static final String STR_REGINFO_COMMERCIAL = "cp.reg_info.commercial";
    private DefaultCopyProtection cp;
    private final boolean enabled = AbstractColorWheelApplication.getOS() != AbstractColorWheelApplication.OS.LINUX;

    public CopyProtectionFeature() {
        super(11, FEATURE_NAME);
    }

    @Override
    protected void featureInit(Application app) {
        AbstractColorWheelApplication l_app = (AbstractColorWheelApplication)app;
        if (!this.enabled) {
            return;
        }
        File l_file = new File(l_app.getAppDataDir(), FILE_NAME);
        PropertiesBasedStorage storage = new PropertiesBasedStorage(l_file, System.getProperty(PROPERTY_USER_NAME));
        this.cp = new DefaultCopyProtection(l_app.getLicensingModel(), (PropertyStorage)storage);
        this.setFeaturedObject((Object)this.cp);
        try {
            CopyProtection.setCopyProtection((CopyProtection)this.cp);
        }
        catch (GeneralSecurityException ex) {
            Logger.getLogger(CopyProtectionFeature.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void featureDispose() {
        if (this.isEnabled()) {
            try {
                CopyProtection.stop();
            }
            catch (GeneralSecurityException ex) {
                Logger.getLogger(CopyProtectionFeature.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String getLicenseInfo() {
        String l_text = null;
        if (!this.isEnabled()) {
            return null;
        }
        LicensingModel l_lm = this.cp.getLicensingModel();
        LicenseValidationPolicy l_policy = l_lm.getEffectivePolicy();
        RegistrationInfoAttribute l_reginfoAttribute = (RegistrationInfoAttribute)this.cp.getAttribute("cp.attribute.registration_info");
        String l_firstName = l_reginfoAttribute.getFirstName();
        String l_lastName = l_reginfoAttribute.getLastName();
        String l_email = l_reginfoAttribute.getEmail();
        if (l_policy instanceof ProductEvaluationPolicy) {
            l_text = MessageFormat.format(StringTable.get(STR_REGINFO_EVALUATION), new Integer(((ProductEvaluationPolicy)l_policy).getDayLeft()));
        } else if (l_policy.isValidated()) {
            l_text = l_firstName != null ? l_firstName + " " + l_lastName + "\n" + l_email : l_email;
        } else {
            l_text = StringTable.get(l_lm instanceof SharewareLicense ? STR_REGINFO_SHAREWARE : STR_REGINFO_COMMERCIAL);
            l_text = MessageFormat.format(l_text, "");
        }
        return l_text;
    }
}

