/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.app_core.features;

import com.valeras.app_skeleton.AbstractFeature;
import com.valeras.app_skeleton.Application;
import com.valeras.color_chart.ColorChart;
import com.valeras.color_chart.reader.ColorChartReader;
import com.valeras.color_chart.reader.acb_acad.ACB_PaletteReader;
import com.valeras.color_chart.reader.acb_acad.ACB_PaletteTagMap;
import com.valeras.colorwheel_harmony.app_core.AbstractColorWheelApplication;
import com.valeras.colorwheel_harmony.model.ColorChartManager;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.model.ColorSpaceProvider;
import com.valeras.colorwheel_harmony.resources.HarmonyResources;
import java.awt.color.ColorSpace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ColorChartsFeature
extends AbstractFeature {
    public static final String FEATURE_NAME = "feature.color_charts";
    public static final int FEATURE_ID = 12;
    private static final String ACB_PALETTE_TAG_EXTERNAL_FILE = "acb_palette_tags.dat";
    private static final String ACB_PALETTE_TAG_INTERNAL_FILE = "color_chart_files/acb_palette_tags.properties";
    private static final String FILE_FILTER_PATTERN = "{0} (*.{1})";
    private final ColorChartManager manager = ColorSpaceProvider.getInstance().getColorChartManager();
    private final ArrayList<FileFilter> filters = new ArrayList();
    private final HashMap<String, ColorChartReader> readers = new HashMap();
    private ColorCombineToolkit toolkit = null;
    private JMenuItem[] menuItems = null;
    private AbstractColorWheelApplication application = null;

    public ColorChartsFeature() {
        super(12, FEATURE_NAME);
        this.setFeaturedObject(this.manager);
    }

    @Override
    protected void featureInit(Application app) {
        Collection<ColorChartManager.ReaderTag> l_readers = this.manager.getReaderList();
        this.application = (AbstractColorWheelApplication)app;
        for (ColorChartManager.ReaderTag rt : l_readers) {
            String l_extension = rt.getFileExtension();
            this.filters.add(new FileNameExtensionFilter(MessageFormat.format(FILE_FILTER_PATTERN, rt.getFormatDescription(), l_extension), l_extension));
            this.readers.put(l_extension.toLowerCase(), rt.getReader());
        }
        ACB_PaletteTagMap l_acbPaletteTags = this.loadACB_PaletteTags();
        ACB_PaletteReader.putPaletteTags((Map)l_acbPaletteTags);
    }

    protected ACB_PaletteTagMap loadACB_PaletteTags() {
        ACB_PaletteTagMap l_map = new ACB_PaletteTagMap();
        InputStream l_inStream = null;
        File l_file = new File(this.application.getAppDataDir(), ACB_PALETTE_TAG_EXTERNAL_FILE);
        if (l_file.exists()) {
            try {
                l_inStream = new FileInputStream(l_file);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(ColorChartsFeature.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (l_inStream == null) {
            l_inStream = HarmonyResources.class.getResourceAsStream(ACB_PALETTE_TAG_INTERNAL_FILE);
        }
        try {
            l_map.load(l_inStream);
        }
        catch (IOException ex) {
            Logger.getLogger(ColorChartsFeature.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParseException ex) {
            Logger.getLogger(ColorChartsFeature.class.getName()).log(Level.SEVERE, null, ex);
        }
        return l_map;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public int getAdditionalColorChartNumber() {
        return this.manager.getPoolCapacity();
    }

    public void setAdditionalColorChartMenuItems(JMenuItem[] menuItems) {
        this.menuItems = menuItems;
    }

    public void setToolkit(ColorCombineToolkit toolkit) {
        this.toolkit = toolkit;
    }

    public ColorChart createColorChart() {
        return this.manager.createColorChart();
    }

    public Collection<ColorChart> getColorCharts() {
        return this.manager.getColorCharts();
    }

    public ColorChartManager getManager() {
        return this.manager;
    }

    public void addColorChart(ColorChart colorChart, boolean activate) {
        int l_index = this.manager.addColorChart(colorChart);
        JMenuItem l_item = this.menuItems[l_index];
        l_item.setText(colorChart.getDisplayName());
        l_item.setVisible(true);
        if (activate) {
            this.toolkit.setColorMatchingColorSpace((ColorSpace)colorChart);
            l_item.setSelected(true);
        }
    }

    public Collection<FileFilter> getFileFilters() {
        return Collections.unmodifiableCollection(this.filters);
    }

    public ColorChartReader readerFor(File file) {
        String l_text = file.getAbsolutePath();
        int l_index = l_text.lastIndexOf(".");
        String l_extension = l_index > 0 ? l_text.substring(l_index + 1) : null;
        return l_extension != null ? this.readers.get(l_extension) : null;
    }
}

