/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.app_core.copy_protection;

import com.valeras.app_skeleton.Application;
import com.valeras.app_skeleton.Version;
import com.valeras.colorwheel_harmony.app_core.AbstractColorWheelApplication;
import com.valeras.copy_protection.CopyProtection;
import com.valeras.copy_protection.attributes.ProductKeyAttribute;
import com.valeras.copy_protection.attributes.RegistrationInfoAttribute;
import com.valeras.copy_protection.attributes.TimeAttribute;
import com.valeras.copy_protection.product_key.AbstractProductKeyValidator;
import com.valeras.copy_protection.product_key.ProductKey;
import com.valeras.copy_protection.product_key.ProductKeyParams;
import java.security.GeneralSecurityException;
import java.security.SecurityPermission;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;

public class DefaultProductKeyValidator
extends AbstractProductKeyValidator {
    private static final String NAME = "product_key_validator.v1";
    private static final String STR_NO_ATTRIBUTE = "Required attribute is absent: {0}.";
    private static final String MSG_WRONG_PARAM = "Key parameter:{0} has incompatible value:{1}.";
    private static final String MSG_EXPIRED = "Key expired date is:{0} while {1} is:{2}.";
    private static final int ANY_EMAIL_ACTION = 100;
    private AbstractColorWheelApplication application;
    private ProductKeyAttribute attribute;
    private RegistrationInfoAttribute regInfoAttribute;
    private TimeAttribute timeAttribute;

    DefaultProductKeyValidator() {
        super(NAME);
    }

    public void check(SecurityPermission permission, ProductKey key, ProductKeyParams params) throws GeneralSecurityException {
        Calendar l_now = Calendar.getInstance();
        Calendar l_keyExpired = Calendar.getInstance();
        Calendar l_timestamp = null;
        if (key == null) {
            throw new NullPointerException();
        }
        int l_appId = (Integer)this.acquireParam("param.application.id", params);
        Version l_appVersion = Version.parse((String)this.acquireParam("param.application.version", params));
        String l_email = (String)this.acquireParam("param.user_uid", params);
        Version l_keyAppVersion = Version.parse((String)key.getParam("param.application.version"));
        l_now.setTime(new Date());
        l_keyExpired.setTime((Date)key.getParam("param.key.expiration_date"));
        if (this.timeAttribute != null) {
            l_timestamp = Calendar.getInstance();
            l_timestamp.setTimeInMillis(this.timeAttribute.getRecentTimestamp());
        }
        if (permission.equals(ACTIVATE_PRODUCT)) {
            this.checkParam(key, "param.application.id", new Integer(l_appId));
            try {
                this.checkParam(key, "param.action", new Integer(100));
            }
            catch (GeneralSecurityException ex) {
                this.checkParam(key, "param.user_uid", l_email);
            }
            if (l_appVersion.major() != l_keyAppVersion.major() && l_appVersion.minor() != l_keyAppVersion.minor()) {
                throw new GeneralSecurityException(MessageFormat.format(MSG_WRONG_PARAM, "param.application.version", l_keyAppVersion));
            }
            if (l_now.after(l_keyExpired)) {
                throw new GeneralSecurityException(MessageFormat.format(MSG_EXPIRED, l_keyExpired.getTime(), "current date", l_now.getTime()));
            }
            if (l_timestamp != null && l_timestamp.after(l_keyExpired)) {
                throw new GeneralSecurityException(MessageFormat.format(MSG_EXPIRED, l_keyExpired.getTime(), "recent timestamp", l_timestamp.getTime()));
            }
        } else if (permission.equals(VALIDATE_LICENSE) && l_appVersion.major() != l_keyAppVersion.major()) {
            throw new GeneralSecurityException(MessageFormat.format(MSG_WRONG_PARAM, "param.application.version", l_keyAppVersion));
        }
    }

    protected Object provideParam(String name) {
        Object l_value = null;
        if (name.equals("param.application.id")) {
            l_value = new Integer(this.application.getAppId());
        } else if (name.equals("param.application.version")) {
            l_value = this.application.getVersion();
        } else if (name.equals("param.user_uid")) {
            l_value = this.regInfoAttribute.getEmail();
        }
        return l_value;
    }

    public void componentInit(CopyProtection cp) {
        this.application = (AbstractColorWheelApplication)Application.getInstance();
        this.attribute = (ProductKeyAttribute)cp.getAttribute("cp.attribute.product_key");
        if (this.attribute == null) {
            throw new NullPointerException(MessageFormat.format(STR_NO_ATTRIBUTE, "cp.attribute.product_key"));
        }
        this.regInfoAttribute = (RegistrationInfoAttribute)cp.getAttribute("cp.attribute.registration_info");
        if (this.regInfoAttribute == null) {
            throw new NullPointerException(MessageFormat.format(STR_NO_ATTRIBUTE, "cp.attribute.registration_info"));
        }
        this.timeAttribute = (TimeAttribute)cp.getAttribute("cp.attribute.time");
    }
}

