/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.app_core.copy_protection;

import com.valeras.colorwheel_harmony.app_core.copy_protection.DefaultProductKeyValidator;
import com.valeras.copy_protection.CopyProtection;
import com.valeras.copy_protection.LicensingModel;
import com.valeras.copy_protection.PropertyStorage;
import com.valeras.copy_protection.SecurityAttribute;
import com.valeras.copy_protection.SecurityPolicy;
import com.valeras.copy_protection.attributes.EvaluationPeriodAttribute;
import com.valeras.copy_protection.attributes.ProductKeyAttribute;
import com.valeras.copy_protection.attributes.RegistrationInfoAttribute;
import com.valeras.copy_protection.attributes.TimeAttribute;
import com.valeras.copy_protection.policies.ProductKeyPolicy;
import com.valeras.copy_protection.policies.PropertyStoragePolicy;
import com.valeras.copy_protection.policies.TimePolicy;
import com.valeras.copy_protection.product_key.ProductKeyBuilder;
import com.valeras.copy_protection.product_key.ProductKeyFormat;
import com.valeras.copy_protection.product_key.ProductKeyValidator;
import com.valeras.copy_protection.product_key.sample_format.ProductKeyFormatS0;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class DefaultCopyProtection
extends CopyProtection {
    private static final String PASSWORD = "darkslateblue";
    private static final int OFFSET = 4;
    private final ProductKeyFormat keyFormat;
    private ProductKeyBuilder keyBuilder;
    private Key key;
    private Cipher cipher;
    private MessageDigest messageDigest;

    public DefaultCopyProtection(LicensingModel licensingModel, PropertyStorage storage) {
        super(licensingModel, storage);
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            this.messageDigest = null;
            Logger.getLogger(DefaultCopyProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.keyFormat = new ProductKeyFormatS0(this.messageDigest, Charset.forName("UTF-8"));
        ProductKeyFormat.addFormat((ProductKeyFormat)this.keyFormat);
        this.key = this.getKey();
        try {
            this.cipher = Cipher.getInstance("DES/ECB/NOPADDING");
        }
        catch (Exception ex) {
            Logger.getLogger(DefaultCopyProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.keyBuilder = new ProductKeyBuilder(this.keyFormat, this.cipher, this.key);
        this.addAttribute((SecurityAttribute)new TimeAttribute());
        this.addAttribute((SecurityAttribute)new EvaluationPeriodAttribute());
        this.addAttribute((SecurityAttribute)new RegistrationInfoAttribute());
        this.addAttribute((SecurityAttribute)new ProductKeyAttribute(this.keyBuilder));
        this.addPolicy((SecurityPolicy)new TimePolicy());
        this.addPolicy((SecurityPolicy)new PropertyStoragePolicy());
        this.addPolicy((SecurityPolicy)new ProductKeyPolicy((ProductKeyValidator)new DefaultProductKeyValidator()));
    }

    private Key getKey() {
        DESKeySpec l_keySpec = null;
        SecretKeyFactory l_keyFactory = null;
        SecretKey l_key = null;
        try {
            l_keySpec = new DESKeySpec(PASSWORD.getBytes(Charset.forName("UTF-8")), 4);
        }
        catch (InvalidKeyException ex) {
            Logger.getLogger(DefaultCopyProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            l_keyFactory = SecretKeyFactory.getInstance("DES");
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(DefaultCopyProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            l_key = l_keyFactory.generateSecret(l_keySpec);
        }
        catch (InvalidKeySpecException ex) {
            Logger.getLogger(DefaultCopyProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return l_key;
    }
}

