/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.app_core.copy_protection;

import com.valeras.colorwheel_harmony.app_core.copy_protection.license.AbstractSoftwareLicense;
import com.valeras.colorwheel_harmony.app_core.copy_protection.license.CommercialLicense;
import com.valeras.colorwheel_harmony.app_core.copy_protection.license.SharewareLicense;
import com.valeras.copy_protection.LicenseValidationPolicy;
import com.valeras.copy_protection.LicensingModel;
import com.valeras.copy_protection.ProductFunctionality;
import com.valeras.copy_protection.policies.ProductEvaluationPolicy;
import com.valeras.copy_protection.policies.ProductFunctionalityPolicy;
import com.valeras.copy_protection.policies.ProductKeyValidationPolicy;

public class ApplicationLicenseProvider {
    public static final String SHAREWARE_LICENSE = "license.shareware";
    public static final String COMMERCIAL_LICENSE = "license.commercial";
    private static final int[] DEFAULT_REMINDERS = new int[]{14, 7, 3, 1};
    private static final int DEFAULT_PERIOD = 30;

    public static LicensingModel provide(String license) {
        AbstractSoftwareLicense l_licensingModel = null;
        ProductKeyValidationPolicy l_licensePolicy = new ProductKeyValidationPolicy();
        if (license.equalsIgnoreCase(SHAREWARE_LICENSE)) {
            ProductFunctionalityPolicy l_functionalityPolicy = new ProductFunctionalityPolicy(ProductFunctionality.LIMITED_FUNCTIONALITY);
            l_licensingModel = new SharewareLicense((LicenseValidationPolicy)l_licensePolicy, new ProductEvaluationPolicy(30, DEFAULT_REMINDERS), l_functionalityPolicy);
        } else if (license.equalsIgnoreCase(COMMERCIAL_LICENSE)) {
            ProductFunctionalityPolicy l_functionalityPolicy = new ProductFunctionalityPolicy(ProductFunctionality.LOCKED_FUNCTIONALITY);
            l_licensingModel = new CommercialLicense((LicenseValidationPolicy)l_licensePolicy, new ProductEvaluationPolicy(30, DEFAULT_REMINDERS), l_functionalityPolicy);
        }
        return l_licensingModel;
    }
}

