/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.app_core;

import com.valeras.app_skeleton.Version;
import com.valeras.colorwheel_harmony.app_core.AbstractColorWheelApplication;
import com.valeras.colorwheel_harmony.app_core.ApplicationSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateAssistant {
    public static final int HINT_OK = 0;
    public static final int HINT_APPDATA_CORRUPTED = 1;
    public static final int HINT_APP_INSTALLED = 2;
    public static final int HINT_APP_UPDATED = 3;
    public static final int HINT_APP_UPGRADED = 4;
    public static final int HINT_APP_DOWNGRADED = 5;
    private static final String MSG_DONT_MODIFY = "DO NOT MODIFY THIS FILE!";
    private static final String MSG_APP_DATA_CORRUPTED = "Application data file {0} is corrupted.";
    private static final String SETUP_FILE_NAME = "setup.dat";
    private static final String PROPERTY_VERSION = "version";
    private File setupFile;
    private final Properties properties = new Properties();
    private boolean corrupted = false;
    private int hint = 0;

    public void assistantInit(AbstractColorWheelApplication app) {
        ApplicationSettings l_settings = app.getSettings();
        this.setupFile = new File(this.getInstallDir(), SETUP_FILE_NAME);
        try {
            FileInputStream l_is = new FileInputStream(this.setupFile);
            this.properties.load(l_is);
        }
        catch (IOException ex) {
            this.corrupted = true;
            this.hint = 1;
            Logger.getLogger(UpdateAssistant.class.getName()).log(Level.SEVERE, MessageFormat.format(MSG_APP_DATA_CORRUPTED, this.setupFile), ex);
            return;
        }
        String l_version = this.properties.getProperty(PROPERTY_VERSION);
        if (l_version == null) {
            this.corrupted = true;
            this.hint = 1;
            return;
        }
        String l_appVersion = app.getVersion();
        String l_currentVersion = l_settings.getVersion();
        if (l_currentVersion == null) {
            l_settings.setVersion(l_appVersion);
            this.hint = 2;
        } else {
            Version verCurrent;
            Version verApp = Version.parse(l_appVersion);
            int l_int = verApp.compareTo(verCurrent = Version.parse(l_currentVersion));
            this.hint = l_int < 0 ? (verApp.major() < verCurrent.major() ? 5 : 3) : (l_int > 0 ? (verApp.major() > verCurrent.major() ? 4 : 3) : 0);
            if (l_int != 0) {
                l_settings.setVersion(l_appVersion);
            }
        }
    }

    public String getInstallDir() {
        String l_path = null;
        String l_classPath = System.getProperty("java.class.path");
        StringTokenizer l_st = new StringTokenizer(l_classPath, File.pathSeparator);
        while (l_st.hasMoreTokens()) {
            String l_token = l_st.nextToken();
            if (!l_token.endsWith("colorwheel_harmony.jar")) continue;
            l_path = new File(l_token).getParent();
            break;
        }
        return l_path;
    }

    public boolean isAppDataCorrupted() {
        return this.corrupted;
    }

    protected void updateProperties() throws IOException {
        FileOutputStream l_os = new FileOutputStream(this.setupFile);
        this.properties.store(l_os, MSG_DONT_MODIFY);
    }

    public int getHint() {
        return this.hint;
    }
}

