/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.app_core;

import com.valeras.colorwheel_harmony.ui.swing.AbstractApplicationIconFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;

public class HarmonySplashScreen {
    private static final int DEFAULT_TITLE_FONT_SIZE = 24;
    private static final Insets DEFAULT_TITLE_INSETS = new Insets(6, 6, 0, 6);
    private static final Insets DEFAULT_TEXT_INSETS = new Insets(3, 3, 3, 3);
    private static final int DEFAULT_IMAGE_WIDTH = 320;
    private static final int DEFAULT_IMAGE_HEIGHT = 240;
    private static final Color GRADIENT_COLOR1 = Color.white;
    private static final Color GRADIENT_COLOR2 = new Color(255, 248, 220);
    private static HarmonySplashScreen instance;

    protected HarmonySplashScreen() {
    }

    public void writeSplashScreen() {
        BufferedImage l_image = HarmonySplashScreen.getInstance().createSplashScreen("ColorWheel Harmony", "Loading...");
        try {
            ImageIO.write((RenderedImage)l_image, "png", new File("c:\\harmony.png"));
        }
        catch (IOException ex) {
            Logger.getLogger(HarmonySplashScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public BufferedImage createSplashScreen(String title, String text) {
        int l_iconWidth;
        BufferedImage l_image = null;
        l_image = new BufferedImage(320, 240, 1);
        Graphics2D l_gr = l_image.createGraphics();
        l_gr.setBackground(Color.white);
        l_gr.clearRect(0, 0, 320, 240);
        l_gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int l_titleFontSize = 24;
        int l_textFontSize = (int)((float)l_titleFontSize * 0.75f);
        Font l_titleFont = new Font("Serif", 0, l_titleFontSize);
        Font l_textFont = new Font("SansSerif", 2, l_textFontSize);
        FontMetrics l_titleFontMetrics = l_gr.getFontMetrics(l_titleFont);
        FontMetrics l_textFontMetrics = l_gr.getFontMetrics(l_textFont);
        int l_titleWidth = l_titleFontMetrics.stringWidth(title);
        int l_textWidth = l_textFontMetrics.stringWidth(text);
        int l_iconHeight = l_iconWidth = l_titleFontSize * 2;
        Icon l_icon = AbstractApplicationIconFactory.createApplicationIcon(l_iconWidth, l_iconHeight);
        int l_imageWidth = l_titleWidth > l_textWidth + l_iconWidth ? l_titleWidth + HarmonySplashScreen.DEFAULT_TITLE_INSETS.left + HarmonySplashScreen.DEFAULT_TITLE_INSETS.right + 2 : l_textWidth + l_iconWidth + HarmonySplashScreen.DEFAULT_TEXT_INSETS.left + HarmonySplashScreen.DEFAULT_TEXT_INSETS.right + 2;
        int l_imageHeight = l_iconHeight + l_titleFontMetrics.getHeight() + HarmonySplashScreen.DEFAULT_TITLE_INSETS.top + HarmonySplashScreen.DEFAULT_TITLE_INSETS.bottom + 2;
        GradientPaint l_grad = new GradientPaint(0.0f, 0.0f, GRADIENT_COLOR1, 0.0f, l_imageHeight, GRADIENT_COLOR2);
        l_gr.setPaint(l_grad);
        l_gr.fillRect(0, 0, l_imageWidth, l_imageHeight);
        l_icon.paintIcon(null, l_gr, 1, l_imageHeight - l_iconHeight);
        int l_x = HarmonySplashScreen.DEFAULT_TITLE_INSETS.left;
        int l_baseline = HarmonySplashScreen.DEFAULT_TITLE_INSETS.top + l_titleFontMetrics.getAscent();
        l_gr.setFont(l_titleFont);
        l_gr.setColor(Color.black);
        l_gr.drawString(title, l_x, l_baseline);
        l_x = l_iconWidth + HarmonySplashScreen.DEFAULT_TEXT_INSETS.left + (l_imageWidth - l_iconWidth - HarmonySplashScreen.DEFAULT_TEXT_INSETS.left - HarmonySplashScreen.DEFAULT_TEXT_INSETS.right - l_textWidth) / 2;
        l_baseline = l_imageHeight - HarmonySplashScreen.DEFAULT_TEXT_INSETS.bottom - l_textFontMetrics.getDescent();
        l_gr.setFont(l_textFont);
        l_gr.setColor(Color.black);
        l_gr.drawString(text, l_x, l_baseline);
        l_gr.setColor(Color.black);
        l_gr.drawRect(0, 0, l_imageWidth - 1, l_imageHeight - 1);
        l_gr.dispose();
        return l_image.getSubimage(0, 0, l_imageWidth, l_imageHeight);
    }

    public static HarmonySplashScreen getInstance() {
        if (instance == null) {
            instance = new HarmonySplashScreen();
        }
        return instance;
    }
}

