/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.app_core;

import com.valeras.cns.ColorNamingSystem;
import com.valeras.cns.color_wheel.ColorWheelCNS;
import com.valeras.color_chart.ColorChart;
import com.valeras.colorimetry.CIE_ColourDifference;
import com.valeras.colorimetry.colour_difference.CIE94Formula;
import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.actions.EditAddBlueFlavorAction;
import com.valeras.colorwheel_harmony.actions.EditAddCommentAction;
import com.valeras.colorwheel_harmony.actions.EditAddGreenFlavorAction;
import com.valeras.colorwheel_harmony.actions.EditAddRedFlavorAction;
import com.valeras.colorwheel_harmony.actions.EditAddYellowFlavorAction;
import com.valeras.colorwheel_harmony.actions.EditColorComponentsAction;
import com.valeras.colorwheel_harmony.actions.EditCopyAction;
import com.valeras.colorwheel_harmony.actions.EditCutAction;
import com.valeras.colorwheel_harmony.actions.EditDeleteAction;
import com.valeras.colorwheel_harmony.actions.EditEnterColorCodeAction;
import com.valeras.colorwheel_harmony.actions.EditPasteAction;
import com.valeras.colorwheel_harmony.actions.FileExitAction;
import com.valeras.colorwheel_harmony.actions.FileExportAction;
import com.valeras.colorwheel_harmony.actions.FileImportAction;
import com.valeras.colorwheel_harmony.actions.FileLoadColorChartAction;
import com.valeras.colorwheel_harmony.actions.FileLoadImageAction;
import com.valeras.colorwheel_harmony.actions.FileNewAction;
import com.valeras.colorwheel_harmony.actions.FileOpenAction;
import com.valeras.colorwheel_harmony.actions.FilePageSetupAction;
import com.valeras.colorwheel_harmony.actions.FilePrintAction;
import com.valeras.colorwheel_harmony.actions.FilePrintImageAction;
import com.valeras.colorwheel_harmony.actions.FileSaveAction;
import com.valeras.colorwheel_harmony.actions.FileSaveAsAction;
import com.valeras.colorwheel_harmony.actions.FileWriteImageAction;
import com.valeras.colorwheel_harmony.actions.HelpAboutAction;
import com.valeras.colorwheel_harmony.actions.HelpContactSupportAction;
import com.valeras.colorwheel_harmony.actions.HelpContentsAction;
import com.valeras.colorwheel_harmony.actions.HelpPurchaseAction;
import com.valeras.colorwheel_harmony.actions.HelpVisitWebSiteAction;
import com.valeras.colorwheel_harmony.actions.SelectColorSchemeAction;
import com.valeras.colorwheel_harmony.actions.ToolsCaptureScreenAction;
import com.valeras.colorwheel_harmony.actions.ToolsColorSpyAction;
import com.valeras.colorwheel_harmony.actions.ToolsOptionsAction;
import com.valeras.colorwheel_harmony.actions.ToolsSetColorMatchingNoneAction;
import com.valeras.colorwheel_harmony.actions.ToolsSetMatchingColorChartAction;
import com.valeras.colorwheel_harmony.actions.ViewColorChartWindowAction;
import com.valeras.colorwheel_harmony.actions.ViewLabelPaletteColorsAction;
import com.valeras.colorwheel_harmony.actions.ViewLabelSelectedColorAction;
import com.valeras.colorwheel_harmony.actions.ViewSelectColorToolAction;
import com.valeras.colorwheel_harmony.actions.ViewSelectPaletteLayoutAction;
import com.valeras.colorwheel_harmony.actions.copy_protection.CPOpenProductKeyDialogAction;
import com.valeras.colorwheel_harmony.actions.filters.GradientFilterAction;
import com.valeras.colorwheel_harmony.actions.filters.SeamlessTextureFilterAction;
import com.valeras.colorwheel_harmony.app_core.AbstractColorWheelApplication;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.app_core.copy_protection.ApplicationLicenseProvider;
import com.valeras.colorwheel_harmony.app_core.features.ColorChartsFeature;
import com.valeras.colorwheel_harmony.document.SupportedFileFormats;
import com.valeras.colorwheel_harmony.model.ColorDetails;
import com.valeras.colorwheel_harmony.model.ColorSpaceProvider;
import com.valeras.copy_protection.CopyProtection;
import com.valeras.copy_protection.LicensingModel;
import com.valeras.copy_protection.ProductFunctionality;
import com.valeras.mdi.FileType;
import com.valeras.mdi.SingleDocumentManager;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class ColorWheelHarmonyApplication
extends AbstractColorWheelApplication {
    public static final String NAME = "ColorWheel Harmony";
    private static final String INTERNAL_NAME = "colorwheel_harmony";
    private static final String VERSION = "2.2";
    private static final int APP_ID = 100;

    public ColorWheelHarmonyApplication() {
        super(NAME);
        FileType[] l_supportedFileTypes = new FileType[]{SupportedFileFormats.GIMP_FILE_TYPE, SupportedFileFormats.PAINTNET_FILE_TYPE};
        this.documentManager = new SingleDocumentManager(this.defaultFileType, l_supportedFileTypes);
        ColorDetails.setUCL((ColorNamingSystem)new ColorWheelCNS());
    }

    @Override
    public int getAppId() {
        return 100;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    protected String getInternalName() {
        return INTERNAL_NAME;
    }

    @Override
    protected void applicationInit() {
        super.applicationInit();
        ((AbstractApplicationAction)this.actions.get("action.view.show_selected_color")).putValue("SwingSelectedKey", this.settings.getLabelSelectedColorEnabled());
        ((AbstractApplicationAction)this.actions.get("action.view.show_palette_colors")).putValue("SwingSelectedKey", this.settings.getLabelPaletteColorsEnabled());
        JMenuItem l_menuItem = this.getMenuItem(ViewSelectPaletteLayoutAction.commandName(this.settings.getColorPaletteLayout()));
        l_menuItem.setSelected(true);
        String l_matchingColorSystem = this.settings.getMatchingColorSystem();
        l_menuItem = null;
        if (l_matchingColorSystem != null && !l_matchingColorSystem.isEmpty()) {
            l_menuItem = this.getMenuItem(ToolsSetMatchingColorChartAction.commandName(l_matchingColorSystem));
        }
        if (l_menuItem == null) {
            l_menuItem = this.getMenuItem("action.tools.match_color_chart.none");
        }
        l_menuItem.setSelected(true);
        l_menuItem = this.getMenuItem("action.copy_protection.enter_pak");
        l_menuItem.setEnabled(CopyProtection.isEnabled());
    }

    @Override
    protected AbstractApplicationAction[] createActions() {
        ArrayList<AbstractApplicationAction> l_actions = new ArrayList<AbstractApplicationAction>();
        ColorChartsFeature l_colorChartsFeature = (ColorChartsFeature)this.getFeature(12);
        l_actions.add(new FileNewAction());
        l_actions.add(new FileOpenAction());
        l_actions.add(new FileSaveAction());
        l_actions.add(new FileSaveAsAction());
        l_actions.add(new FileLoadImageAction());
        l_actions.add(new FileWriteImageAction());
        l_actions.add(new FileImportAction());
        l_actions.add(new FileExportAction());
        l_actions.add(new FilePageSetupAction());
        l_actions.add(new FilePrintAction());
        l_actions.add(new FilePrintImageAction());
        l_actions.add(new FileExitAction());
        l_actions.add(new EditCutAction());
        l_actions.add(new EditCopyAction());
        l_actions.add(new EditPasteAction());
        l_actions.add(new EditDeleteAction());
        l_actions.add(new EditColorComponentsAction());
        l_actions.add(new EditEnterColorCodeAction());
        l_actions.add(new EditAddCommentAction());
        l_actions.add(new SelectColorSchemeAction("color_scheme.analogous"));
        l_actions.add(new SelectColorSchemeAction("color_scheme.complementary"));
        l_actions.add(new SelectColorSchemeAction("color_scheme.double_complementary"));
        l_actions.add(new SelectColorSchemeAction("color_scheme.monochromatic"));
        l_actions.add(new SelectColorSchemeAction("color_scheme.split_complementary"));
        l_actions.add(new SelectColorSchemeAction("color_scheme.triadic"));
        l_actions.add(new EditAddRedFlavorAction());
        l_actions.add(new EditAddGreenFlavorAction());
        l_actions.add(new EditAddBlueFlavorAction());
        l_actions.add(new EditAddYellowFlavorAction());
        l_actions.add(new ViewSelectColorToolAction("mode.color_wheel"));
        l_actions.add(new ViewSelectColorToolAction("mode.contrast_pattern"));
        l_actions.add(new ViewSelectColorToolAction("mode.color_picker"));
        l_actions.add(new ViewSelectPaletteLayoutAction("color_palette_layout.default_2r4c"));
        l_actions.add(new ViewSelectPaletteLayoutAction("color_palette_layout.artistic_60x30x10"));
        l_actions.add(new ViewColorChartWindowAction());
        l_actions.add(new ViewLabelSelectedColorAction());
        l_actions.add(new ViewLabelPaletteColorsAction());
        l_actions.add(new ToolsSetColorMatchingNoneAction());
        int l_poolSize = l_colorChartsFeature.getAdditionalColorChartNumber();
        Collection<ColorChart> l_colorCharts = l_colorChartsFeature.getColorCharts();
        for (ColorChart cc : l_colorCharts) {
            l_actions.add(new ToolsSetMatchingColorChartAction(cc.getName()));
        }
        for (int i = 0; i < l_poolSize; ++i) {
            l_actions.add(new ToolsSetMatchingColorChartAction(i));
        }
        l_actions.add(new FileLoadColorChartAction());
        l_actions.add(new ToolsColorSpyAction((CIE_ColourDifference)new CIE94Formula()));
        l_actions.add(new SeamlessTextureFilterAction());
        l_actions.add(new GradientFilterAction());
        l_actions.add(new ToolsCaptureScreenAction());
        l_actions.add(new ToolsOptionsAction());
        l_actions.add(new HelpContentsAction());
        l_actions.add(new HelpVisitWebSiteAction());
        l_actions.add(new HelpContactSupportAction());
        l_actions.add(new HelpPurchaseAction());
        l_actions.add(new CPOpenProductKeyDialogAction());
        l_actions.add(new HelpAboutAction());
        AbstractApplicationAction[] l_array = new AbstractApplicationAction[l_actions.size()];
        return l_actions.toArray(l_array);
    }

    @Override
    protected JMenuBar createMenuBar() {
        ColorChartsFeature l_colorChartsFeature = (ColorChartsFeature)this.getFeature(12);
        int l_keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuBar l_menuBar = new JMenuBar();
        JMenu l_menuFile = new JMenu(StringTable.get("menu.file.name"));
        JMenu l_menuEdit = new JMenu(StringTable.get("menu.edit.name"));
        JMenu l_menuView = new JMenu(StringTable.get("menu.view.name"));
        JMenu l_menuTools = new JMenu(StringTable.get("menu.tools.name"));
        JMenu l_menuHelp = new JMenu(StringTable.get("menu.help.name"));
        l_menuBar.add(l_menuFile);
        l_menuBar.add(l_menuEdit);
        l_menuBar.add(l_menuView);
        l_menuBar.add(l_menuTools);
        l_menuBar.add(l_menuHelp);
        l_menuFile.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.file.new"), KeyStroke.getKeyStroke(78, l_keyMask)));
        l_menuFile.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.file.open"), KeyStroke.getKeyStroke(79, l_keyMask)));
        l_menuFile.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.file.save"), KeyStroke.getKeyStroke(83, l_keyMask)));
        l_menuFile.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.file.saveas")));
        l_menuFile.addSeparator();
        l_menuFile.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.file.load_image")));
        l_menuFile.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.file.write_image")));
        l_menuFile.addSeparator();
        l_menuFile.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.file.import")));
        l_menuFile.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.file.export")));
        l_menuFile.addSeparator();
        l_menuFile.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.file.page_setup")));
        l_menuFile.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.file.print"), KeyStroke.getKeyStroke(80, l_keyMask)));
        l_menuFile.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.file.print_image")));
        l_menuFile.addSeparator();
        l_menuFile.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.file.exit")));
        l_menuEdit.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.edit.cut"), KeyStroke.getKeyStroke(88, l_keyMask)));
        l_menuEdit.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.edit.copy"), KeyStroke.getKeyStroke(67, l_keyMask)));
        l_menuEdit.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.edit.paste"), KeyStroke.getKeyStroke(86, l_keyMask)));
        l_menuEdit.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.edit.delete"), KeyStroke.getKeyStroke(127, 0)));
        l_menuEdit.addSeparator();
        l_menuEdit.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.edit.color"), KeyStroke.getKeyStroke(69, l_keyMask)));
        l_menuEdit.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.edit.enter_color_code"), KeyStroke.getKeyStroke(10, 0)));
        l_menuEdit.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.edit.comment")));
        l_menuEdit.addSeparator();
        l_menuEdit.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.edit.add_red"), KeyStroke.getKeyStroke(82, l_keyMask)));
        l_menuEdit.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.edit.add_green"), KeyStroke.getKeyStroke(71, l_keyMask)));
        l_menuEdit.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.edit.add_blue"), KeyStroke.getKeyStroke(66, l_keyMask)));
        l_menuEdit.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.edit.add_yellow"), KeyStroke.getKeyStroke(89, l_keyMask)));
        l_menuView.add(this.createMenuItem((AbstractApplicationAction)this.actions.get(ViewSelectColorToolAction.commandName("mode.color_wheel")), KeyStroke.getKeyStroke(49, l_keyMask)));
        l_menuView.add(this.createMenuItem((AbstractApplicationAction)this.actions.get(ViewSelectColorToolAction.commandName("mode.contrast_pattern")), KeyStroke.getKeyStroke(50, l_keyMask)));
        l_menuView.add(this.createMenuItem((AbstractApplicationAction)this.actions.get(ViewSelectColorToolAction.commandName("mode.color_picker")), KeyStroke.getKeyStroke(51, l_keyMask)));
        l_menuView.addSeparator();
        l_menuView.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.view.color_chart_window"), KeyStroke.getKeyStroke(84, l_keyMask)));
        l_menuView.addSeparator();
        ButtonGroup l_group = new ButtonGroup();
        JRadioButtonMenuItem l_item = this.createRadioButtonMenuItem((AbstractApplicationAction)this.actions.get(ViewSelectPaletteLayoutAction.commandName("color_palette_layout.default_2r4c")));
        l_group.add(l_item);
        l_menuView.add(l_item);
        l_item = this.createRadioButtonMenuItem((AbstractApplicationAction)this.actions.get(ViewSelectPaletteLayoutAction.commandName("color_palette_layout.artistic_60x30x10")));
        l_group.add(l_item);
        l_menuView.add(l_item);
        l_menuView.addSeparator();
        l_menuView.add(this.createCheckBoxMenuItem((AbstractApplicationAction)this.actions.get("action.view.show_selected_color")));
        l_menuView.add(this.createCheckBoxMenuItem((AbstractApplicationAction)this.actions.get("action.view.show_palette_colors")));
        JMenu l_subMenuColorMatching = new JMenu(StringTable.get("menu.match_color_chart.name"));
        l_group = new ButtonGroup();
        l_item = this.createRadioButtonMenuItem((AbstractApplicationAction)this.actions.get("action.tools.match_color_chart.none"));
        l_group.add(l_item);
        l_subMenuColorMatching.add(l_item);
        l_subMenuColorMatching.addSeparator();
        Collection<ColorChart> l_colorCharts = l_colorChartsFeature.getColorCharts();
        for (ColorChart cc : l_colorCharts) {
            l_item = this.createRadioButtonMenuItem((AbstractApplicationAction)this.actions.get(ToolsSetMatchingColorChartAction.commandName(cc.getName())));
            l_group.add(l_item);
            l_subMenuColorMatching.add(l_item);
        }
        int l_poolSize = l_colorChartsFeature.getAdditionalColorChartNumber();
        JMenuItem[] l_pool = new JMenuItem[l_poolSize];
        for (int i = 0; i < l_poolSize; ++i) {
            l_item = this.createRadioButtonMenuItem((AbstractApplicationAction)this.actions.get(ToolsSetMatchingColorChartAction.commandName(i)));
            l_item.setVisible(false);
            l_pool[i] = l_item;
            l_group.add(l_item);
            l_subMenuColorMatching.add(l_item);
        }
        l_colorChartsFeature.setAdditionalColorChartMenuItems(l_pool);
        l_subMenuColorMatching.addSeparator();
        l_subMenuColorMatching.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.file.load_color_chart")));
        l_menuTools.add(l_subMenuColorMatching);
        l_menuTools.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.tools.color_spy")));
        l_menuTools.addSeparator();
        l_menuTools.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.filter.gradient")));
        l_menuTools.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.filter.seamless_texture")));
        l_menuTools.addSeparator();
        l_menuTools.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.tools.capture_screen"), KeyStroke.getKeyStroke(120, 0)));
        l_menuTools.addSeparator();
        l_menuTools.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.tools.options")));
        l_menuHelp.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.help.contents"), KeyStroke.getKeyStroke(112, 0)));
        l_menuHelp.addSeparator();
        l_menuHelp.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.help.visit_website")));
        l_menuHelp.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.help.contact_support")));
        l_menuHelp.addSeparator();
        l_menuHelp.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.help.purchase")));
        l_menuHelp.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.copy_protection.enter_pak")));
        l_menuHelp.addSeparator();
        l_menuHelp.add(this.createMenuItem((AbstractApplicationAction)this.actions.get("action.help.about")));
        return l_menuBar;
    }

    @Override
    public LicensingModel getLicensingModel() {
        return ApplicationLicenseProvider.provide("license.commercial");
    }

    @Override
    public void setFunctionality(ProductFunctionality functionality) {
        if (functionality.equals((Object)ProductFunctionality.LIMITED_FUNCTIONALITY)) {
            ((AbstractApplicationAction)this.actions.get("action.file.save")).setEnabled(false);
            ((AbstractApplicationAction)this.actions.get("action.file.saveas")).setEnabled(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String l_property = evt.getPropertyName();
        if (l_property.equals("cmyk_profile")) {
            ColorSpaceProvider.getInstance().setCMYKProfile((String)evt.getNewValue());
        }
    }
}

