/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.app_core;

import com.valeras.colorwheel_harmony.resources.HarmonyResources;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class ApplicationSettings {
    public static final String PROPERTY_COLOR_SCHEME = "color_scheme";
    public static final String PROPERTY_COLOR_PALETTE_LAYOUT = "color_palette_layout";
    public static final String PROPERTY_LABEL_SELECTED_COLOR = "label_selected_color";
    public static final String PROPERTY_LABEL_PALETTE_COLORS = "label_palette_colors";
    public static final String PROPERTY_COLORWHEEL_COVER = "colorwheel_cover";
    public static final String PROPERTY_MATCHING_COLOR_SYSTEM = "matching_cs";
    public static final String PROPERTY_LARGE_COLOR_CARDS = "large_color_cards";
    public static final String PROPERTY_DARK_BACKGROUND = "dark_background";
    public static final String PROPERTY_DEFAULT_LNF = "default_lnf";
    public static final String PROPERTY_SCREEN_CAPTURE_DELAY = "screen_capture_delay";
    public static final String PROPERTY_CMYK_PROFILE = "cmyk_profile";
    public static final String PROPERTY_VERSION = "version";
    public static final String PROPERTY_LANGUAGE = "language";
    private final Preferences preferences;
    private final String preferencesNodeName;
    private final Properties defaults;
    private final ArrayList<PropertyChangeListener> propertyChangeListeners = new ArrayList();

    public ApplicationSettings(String preferencesNodeName) {
        this.preferencesNodeName = preferencesNodeName;
        this.preferences = Preferences.userRoot().node(this.preferencesNodeName);
        this.defaults = new Properties();
        try {
            this.defaults.load(HarmonyResources.class.getResourceAsStream("settings/default_settings.properties"));
        }
        catch (IOException ex) {
            Logger.getLogger(ApplicationSettings.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected boolean getBooleanDefaults(String propertyKey) {
        String l_value = this.defaults.getProperty(propertyKey, null);
        if (l_value != null) {
            return Boolean.parseBoolean(l_value);
        }
        return false;
    }

    protected String getDefaults(String propertyKey) {
        return this.defaults.getProperty(propertyKey);
    }

    public String getColorScheme() {
        return this.preferences.get(PROPERTY_COLOR_SCHEME, this.getDefaults(PROPERTY_COLOR_SCHEME));
    }

    public void setColorScheme(String colorSchemeName) {
        this.preferences.put(PROPERTY_COLOR_SCHEME, colorSchemeName);
    }

    public String getCMYKProfile() {
        return this.preferences.get(PROPERTY_CMYK_PROFILE, this.getDefaults(PROPERTY_CMYK_PROFILE));
    }

    public void setCMYKProfile(String profile) {
        String l_oldValue = this.getCMYKProfile();
        this.preferences.put(PROPERTY_CMYK_PROFILE, profile);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_CMYK_PROFILE, l_oldValue, profile));
    }

    public String getVersion() {
        return this.preferences.get(PROPERTY_VERSION, null);
    }

    public void setVersion(String version) {
        this.preferences.put(PROPERTY_VERSION, version);
    }

    public Locale getLanguage() {
        Locale l_locale;
        String l_text = this.preferences.get(PROPERTY_LANGUAGE, null);
        if (l_text == null || l_text.isEmpty()) {
            l_locale = null;
        } else {
            String l_language = l_text.substring(0, 2);
            String l_country = l_text.substring(3);
            l_locale = new Locale(l_language, l_country);
        }
        return l_locale;
    }

    public void setLanguage(Locale locale) {
        String l_text = locale != null ? locale.getLanguage() + "_" + locale.getCountry() : "";
        this.preferences.put(PROPERTY_LANGUAGE, l_text);
    }

    public String getColorPaletteLayout() {
        return this.preferences.get(PROPERTY_COLOR_PALETTE_LAYOUT, this.getDefaults(PROPERTY_COLOR_PALETTE_LAYOUT));
    }

    public void setColorPaletteLayout(String colorPaletteLayoutName) {
        this.preferences.put(PROPERTY_COLOR_PALETTE_LAYOUT, colorPaletteLayoutName);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_COLOR_PALETTE_LAYOUT, this.getColorPaletteLayout(), colorPaletteLayoutName));
    }

    public String getMatchingColorSystem() {
        return this.preferences.get(PROPERTY_MATCHING_COLOR_SYSTEM, this.getDefaults(PROPERTY_MATCHING_COLOR_SYSTEM));
    }

    public void setMatchingColorSystem(String sName) {
        this.preferences.put(PROPERTY_MATCHING_COLOR_SYSTEM, sName != null ? sName : "");
    }

    public boolean getScreenCaptureDelayEnabled() {
        return this.preferences.getBoolean(PROPERTY_SCREEN_CAPTURE_DELAY, this.getBooleanDefaults(PROPERTY_SCREEN_CAPTURE_DELAY));
    }

    public void setScreenCaptureDelayEnabled(boolean flag) {
        boolean l_oldValue = this.getScreenCaptureDelayEnabled();
        this.preferences.putBoolean(PROPERTY_SCREEN_CAPTURE_DELAY, flag);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_SCREEN_CAPTURE_DELAY, l_oldValue, flag));
    }

    public boolean getLabelSelectedColorEnabled() {
        return this.preferences.getBoolean(PROPERTY_LABEL_SELECTED_COLOR, this.getBooleanDefaults(PROPERTY_LABEL_SELECTED_COLOR));
    }

    public void setLabelSelectedColorEnabled(boolean flag) {
        this.preferences.putBoolean(PROPERTY_LABEL_SELECTED_COLOR, flag);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_LABEL_SELECTED_COLOR, this.getLabelSelectedColorEnabled(), flag));
    }

    public boolean getLabelPaletteColorsEnabled() {
        return this.preferences.getBoolean(PROPERTY_LABEL_PALETTE_COLORS, this.getBooleanDefaults(PROPERTY_LABEL_PALETTE_COLORS));
    }

    public void setLargeColorCards(boolean flag) {
        this.preferences.putBoolean(PROPERTY_LARGE_COLOR_CARDS, flag);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_LARGE_COLOR_CARDS, this.getLargeColorCards(), flag));
    }

    public boolean getLargeColorCards() {
        return this.preferences.getBoolean(PROPERTY_LARGE_COLOR_CARDS, this.getBooleanDefaults(PROPERTY_LARGE_COLOR_CARDS));
    }

    public void setLabelPaletteColorsEnabled(boolean flag) {
        this.preferences.putBoolean(PROPERTY_LABEL_PALETTE_COLORS, flag);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_LABEL_PALETTE_COLORS, this.getLabelPaletteColorsEnabled(), flag));
    }

    public String getColorWheelCover() {
        return this.preferences.get(PROPERTY_COLORWHEEL_COVER, this.getDefaults(PROPERTY_COLORWHEEL_COVER));
    }

    public void setColorWheelCover(String coverName) {
        this.preferences.put(PROPERTY_COLORWHEEL_COVER, coverName);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_COLORWHEEL_COVER, this.getColorWheelCover(), coverName));
    }

    public boolean getDarkBackgroundEnabled() {
        return this.preferences.getBoolean(PROPERTY_DARK_BACKGROUND, this.getBooleanDefaults(PROPERTY_DARK_BACKGROUND));
    }

    public void setDarkBackgroundEnabled(boolean flag) {
        this.preferences.putBoolean(PROPERTY_DARK_BACKGROUND, flag);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_DARK_BACKGROUND, this.getDarkBackgroundEnabled(), flag));
    }

    public boolean getDefaultLNFEnabled() {
        return this.preferences.getBoolean(PROPERTY_DEFAULT_LNF, this.getBooleanDefaults(PROPERTY_DEFAULT_LNF));
    }

    public void setDefaultLNFEnabled(boolean flag) {
        this.preferences.putBoolean(PROPERTY_DEFAULT_LNF, flag);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_DEFAULT_LNF, this.getDefaultLNFEnabled(), flag));
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (PropertyChangeListener l : this.propertyChangeListeners) {
            l.propertyChange(event);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }
}

