/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.app_core;

import com.valeras.app_skeleton.AbstractFeature;
import com.valeras.app_skeleton.Application;
import com.valeras.color_combine.controller.ColorWheelController;
import com.valeras.color_combine.model.ColorScheme;
import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.actions.FileSaveAction;
import com.valeras.colorwheel_harmony.actions.SelectColorSchemeAction;
import com.valeras.colorwheel_harmony.actions.application.ApplicationInformationAction;
import com.valeras.colorwheel_harmony.actions.copy_protection.CPReaction;
import com.valeras.colorwheel_harmony.app_core.Actions;
import com.valeras.colorwheel_harmony.app_core.ApplicationSettings;
import com.valeras.colorwheel_harmony.app_core.StartupActionBunch;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.app_core.UpdateAssistant;
import com.valeras.colorwheel_harmony.app_core.features.ColorChartsFeature;
import com.valeras.colorwheel_harmony.app_core.features.DefaultFeature;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.colorwheel_harmony.document.ColorDocumentFactory;
import com.valeras.colorwheel_harmony.document.ColorDocumentViewFactory;
import com.valeras.colorwheel_harmony.document.DefaultDocumentManagerListener;
import com.valeras.colorwheel_harmony.document.SupportedFileFormats;
import com.valeras.colorwheel_harmony.document.io.chp.CHPReader;
import com.valeras.colorwheel_harmony.document.io.chp.CHPWriter;
import com.valeras.colorwheel_harmony.document.io.gpl_gimp.GPLReader;
import com.valeras.colorwheel_harmony.document.io.gpl_gimp.GPLWriter;
import com.valeras.colorwheel_harmony.document.io.txt_paint_net.TXTReader;
import com.valeras.colorwheel_harmony.document.io.txt_paint_net.TXTWriter;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkitObserver;
import com.valeras.colorwheel_harmony.model.ColorSetter;
import com.valeras.colorwheel_harmony.ui.ApplicationMainWindow;
import com.valeras.colorwheel_harmony.ui.ColorSchemeSelectionPanel;
import com.valeras.colorwheel_harmony.ui.swing.AbstractApplicationIconFactory;
import com.valeras.colorwheel_harmony.ui.swing.windows.ColorChartWindow;
import com.valeras.copy_protection.CopyProtection;
import com.valeras.copy_protection.LicensingModel;
import com.valeras.copy_protection.ProductFunctionality;
import com.valeras.copy_protection.policies.ProductEvaluationPolicy;
import com.valeras.mdi.AbstractDocumentManager;
import com.valeras.mdi.DocumentIO;
import com.valeras.mdi.FileFormat;
import com.valeras.mdi.FileType;
import com.valeras.mdi.event.DocumentManagerListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.security.GeneralSecurityException;
import java.security.PermissionCollection;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;

public abstract class AbstractColorWheelApplication
extends Application
implements PropertyChangeListener {
    private static final String PREFERENCES_NODE = "colorwheel_harmony";
    private static final String STR_APPDATA_CORRUPTED = "application.message.appdata_corrupted";
    private static final String STR_PREFIX_WINDOWS = "windows";
    private static final String STR_PREFIX_MACOS = "mac";
    private static final String STR_PREFIX_LINUX = "linux";
    private static final String KEY_OS_NAME = "os.name";
    private static OS os = null;
    protected final ColorCombineToolkit colorCombineToolkit;
    protected AbstractDocumentManager<AbstractColorDocument> documentManager;
    protected ColorCombineToolkitObserver colorCombineToolkitObserver;
    protected ColorDocumentFactory documentFactory;
    protected ColorDocumentViewFactory viewFactory;
    protected ApplicationMainWindow mainWindow;
    protected final Actions actions;
    private final ActionEvent defaultActionEvent;
    protected final FileType defaultFileType;
    protected final FileFormat nativeFileFormat;
    protected final ApplicationSettings settings = new ApplicationSettings("colorwheel_harmony");
    protected JMenuBar menuBar;

    protected AbstractColorWheelApplication(String name) {
        super(name);
        Locale l_locale = this.settings.getLanguage();
        StringTable.createInstance(l_locale != null ? l_locale : Locale.getDefault());
        this.colorCombineToolkit = new ColorCombineToolkit();
        this.colorCombineToolkitObserver = new ColorCombineToolkitObserver(this.colorCombineToolkit);
        this.defaultActionEvent = new ActionEvent(this, 1001, null);
        this.documentFactory = new ColorDocumentFactory();
        this.viewFactory = new ColorDocumentViewFactory();
        this.defaultFileType = SupportedFileFormats.DEFAULT_FILE_TYPE;
        this.nativeFileFormat = SupportedFileFormats.NATIVE_FILE_FORMAT;
        this.actions = new Actions();
        this.features.add(new DefaultFeature());
        this.features.add(new ColorChartsFeature());
    }

    @Override
    protected void applicationInit() {
        AbstractApplicationAction[] l_actions;
        super.applicationInit();
        this.settings.addPropertyChangeListener(this);
        ColorChartsFeature l_colorChartsFeature = (ColorChartsFeature)this.getFeature("feature.color_charts");
        l_colorChartsFeature.setToolkit(this.colorCombineToolkit);
        DocumentIO.registerReader(new CHPReader(), this.nativeFileFormat);
        DocumentIO.registerWriter(new CHPWriter(), this.nativeFileFormat);
        DocumentIO.registerReader(new GPLReader(), SupportedFileFormats.GIMP_GPL_FILE_FORMAT);
        DocumentIO.registerWriter(new GPLWriter(), SupportedFileFormats.GIMP_GPL_FILE_FORMAT);
        DocumentIO.registerReader(new TXTReader(), SupportedFileFormats.PAINTNET_TXT_FILE_FORMAT);
        DocumentIO.registerWriter(new TXTWriter(), SupportedFileFormats.PAINTNET_TXT_FILE_FORMAT);
        this.documentManager.setDocumentFactory(this.documentFactory);
        this.documentManager.setViewFactory(this.viewFactory);
        this.documentManager.addDocumentListener(this.createDocumentManagerListener());
        this.colorCombineToolkitObserver.setDocumentManager(this.documentManager);
        AbstractApplicationAction.setApplication(this);
        for (AbstractApplicationAction a : l_actions = this.createActions()) {
            this.actions.put(a.getCommand(), a);
        }
        this.mainWindow = this.createMainWindow();
        this.mainWindow.addWindowListener(new CWWindowListener());
        this.colorCombineToolkit.setView(this.mainWindow);
        this.colorCombineToolkit.modelInit(this.settings);
        this.mainWindow.viewInit(this.colorCombineToolkit, this.settings);
        ColorChartWindow l_colorChartView = this.mainWindow.getColorChartWindow();
        l_colorChartView.setColorCharts(l_colorChartsFeature.getColorCharts());
        l_colorChartView.setColorSetter(new ColorSetter(this.colorCombineToolkit));
        this.colorCombineToolkitObserver.setColorWheelController((ColorWheelController)this.mainWindow.getColorWheelComponent().getController());
    }

    public static OS getOS() {
        if (os == null) {
            String l_name = System.getProperty(KEY_OS_NAME);
            os = l_name.toLowerCase().startsWith(STR_PREFIX_WINDOWS) ? OS.WINDOWS : (l_name.toLowerCase().startsWith(STR_PREFIX_MACOS) ? OS.MACOS : (l_name.toLowerCase().startsWith(STR_PREFIX_LINUX) ? OS.LINUX : OS.OTHER));
        }
        return os;
    }

    @Override
    protected void applicationRun(String[] args) {
        final StartupActionBunch l_actions = new StartupActionBunch();
        AbstractColorDocument l_document = null;
        boolean l_ignoreCode = false;
        PermissionCollection l_cpPermissions = CopyProtection.RESET_SECUTITY.newPermissionCollection();
        boolean l_cpReset = false;
        AbstractFeature l_updateFeature = this.getFeature("feature.update_assistant");
        if (l_updateFeature != null) {
            UpdateAssistant l_ua = (UpdateAssistant)l_updateFeature.getFeaturedObject();
            l_cpPermissions.add(CopyProtection.RESET_SECUTITY);
            switch (l_ua.getHint()) {
                case 1: {
                    l_actions.add(new ApplicationInformationAction(MessageFormat.format(StringTable.get(STR_APPDATA_CORRUPTED), this.getName()), 0, true));
                    l_ignoreCode = true;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    l_cpReset = true;
                    l_cpPermissions.add(ProductEvaluationPolicy.RESET_EVALUATION_PERIOD);
                    break;
                }
                case 5: {
                    l_cpReset = false;
                }
            }
        }
        if (!l_ignoreCode && CopyProtection.isEnabled()) {
            CopyProtection l_cp = CopyProtection.getCopyProtection();
            if (l_cpReset) {
                try {
                    l_cp.reset(l_cpPermissions);
                }
                catch (GeneralSecurityException ex) {
                    Logger.getLogger(AbstractColorWheelApplication.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            try {
                l_cp.check();
            }
            catch (GeneralSecurityException ex) {
                Logger.getLogger(AbstractColorWheelApplication.class.getName()).log(Level.SEVERE, null, ex);
            }
            l_actions.add(new CPReaction());
        }
        if (!l_ignoreCode && args != null) {
            for (int i = 0; i < args.length; ++i) {
                File l_file = new File(args[i]);
                if (l_file.exists()) {
                    l_document = (AbstractColorDocument)this.documentFactory.createDocument(this.documentManager.getFileType(l_file).getFileFormat(l_file));
                    try {
                        l_document = this.documentManager.fileOpen(l_file, l_document, false);
                        this.documentManager.add(l_document);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(AbstractColorWheelApplication.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (!this.documentManager.isMultipleDocumentManager()) break;
            }
        }
        if (l_document == null) {
            l_document = this.documentManager.fileNew();
            this.documentManager.add(l_document);
        }
        this.documentManager.setSelectedDocument(l_document);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractColorWheelApplication.this.mainWindow.pack();
                AbstractColorWheelApplication.this.mainWindow.setVisible(true);
                l_actions.run();
            }
        });
    }

    @Override
    protected void applicationQuit() {
        this.mainWindow.dispose();
        super.applicationQuit();
    }

    @Override
    protected boolean canQuit(boolean displayAlerts) {
        String message = "application.message.save_changed_file";
        if (displayAlerts) {
            List<AbstractColorDocument> l_documents = this.documentManager.listDocuments();
            for (AbstractColorDocument d : l_documents) {
                if (!d.isChanged()) continue;
                String l_text = MessageFormat.format(StringTable.get("application.message.save_changed_file"), d.getName());
                int l_option = JOptionPane.showConfirmDialog(this.mainWindow, l_text, this.getName(), 1);
                if (l_option == 0) {
                    new FileSaveAction(d).actionPerformed(null);
                    continue;
                }
                if (l_option != 2 && l_option != -1) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract String getInternalName();

    public abstract LicensingModel getLicensingModel();

    public String getAppDataDir() {
        return System.getProperty("user.home") + File.separator + this.getName();
    }

    public abstract int getAppId();

    public ApplicationSettings getSettings() {
        return this.settings;
    }

    public JMenuItem getMenuItem(String commandName) {
        return this.findMenuItem(this.menuBar, commandName);
    }

    private JMenuItem findMenuItem(MenuElement menu, String commandName) {
        MenuElement[] l_elements;
        JMenuItem l_item = null;
        for (MenuElement e : l_elements = menu.getSubElements()) {
            String l_cmd;
            Action a;
            Component c = e.getComponent();
            if (c instanceof JMenuItem && (a = ((JMenuItem)c).getAction()) != null && commandName.equalsIgnoreCase(l_cmd = (String)a.getValue("ActionCommandKey"))) {
                l_item = (JMenuItem)c;
                break;
            }
            MenuElement[] l_elements2 = e.getSubElements();
            if (l_elements2 != null && l_elements2.length > 0 && (l_item = this.findMenuItem(e, commandName)) != null) break;
        }
        return l_item;
    }

    public ColorCombineToolkit getColorCombineToolkit() {
        return this.colorCombineToolkit;
    }

    protected ApplicationMainWindow createMainWindow() {
        ApplicationMainWindow l_frame = new ApplicationMainWindow();
        l_frame.setTitle(this.getTitle());
        l_frame.setDefaultCloseOperation(0);
        l_frame.setIconImages(AbstractApplicationIconFactory.getInstance().getApplicationIconImages());
        this.menuBar = this.createMenuBar();
        l_frame.setJMenuBar(this.menuBar);
        l_frame.getColorChartWindow().setIconImages(AbstractApplicationIconFactory.getInstance().getColorChartIconImages());
        this.createColorSchemeButtons(l_frame.getColorSchemeSelectionPanel());
        return l_frame;
    }

    public ApplicationMainWindow getMainWindow() {
        return this.mainWindow;
    }

    public String getTitle() {
        return this.getName();
    }

    public AbstractDocumentManager getDocumentManager() {
        return this.documentManager;
    }

    protected DocumentManagerListener createDocumentManagerListener() {
        return new DefaultDocumentManagerListener(this);
    }

    protected void createColorSchemeButtons(ColorSchemeSelectionPanel panel) {
        List l_schemeList = this.colorCombineToolkit.getColorSchemeList();
        for (String n : l_schemeList) {
            SelectColorSchemeAction l_action = (SelectColorSchemeAction)this.actions.get(SelectColorSchemeAction.commandName(n));
            ColorScheme l_colorScheme = this.colorCombineToolkit.getColorScheme(n);
            panel.addColorSchemeButton(l_action, l_colorScheme);
        }
    }

    protected abstract AbstractApplicationAction[] createActions();

    public AbstractApplicationAction getAction(String name) {
        return (AbstractApplicationAction)this.actions.get(name);
    }

    protected abstract JMenuBar createMenuBar();

    protected JMenuItem createMenuItem(AbstractApplicationAction action, KeyStroke keyStroke) {
        JMenuItem l_mi = new JMenuItem(action);
        if (action == null) {
            throw new IllegalArgumentException("Action cannot be null.");
        }
        l_mi.setAccelerator(keyStroke);
        return l_mi;
    }

    protected JMenuItem createMenuItem(AbstractApplicationAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Action cannot be null.");
        }
        return new JMenuItem(action);
    }

    protected JRadioButtonMenuItem createRadioButtonMenuItem(AbstractApplicationAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Action cannot be null.");
        }
        return new JRadioButtonMenuItem(action);
    }

    protected JRadioButtonMenuItem createRadioButtonMenuItem(AbstractApplicationAction action, KeyStroke keyStroke) {
        JRadioButtonMenuItem l_mi = new JRadioButtonMenuItem(action);
        if (action == null) {
            throw new IllegalArgumentException("Action cannot be null.");
        }
        l_mi.setAccelerator(keyStroke);
        return l_mi;
    }

    protected JCheckBoxMenuItem createCheckBoxMenuItem(AbstractApplicationAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Action cannot be null.");
        }
        return new JCheckBoxMenuItem(action);
    }

    public void setFunctionality(ProductFunctionality functionality) {
    }

    private class CWWindowListener
    extends WindowAdapter {
        private CWWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ((AbstractApplicationAction)AbstractColorWheelApplication.this.actions.get("action.file.exit")).actionPerformed(AbstractColorWheelApplication.this.defaultActionEvent);
        }
    }

    public static enum OS {
        WINDOWS,
        MACOS,
        LINUX,
        OTHER;

    }
}

