/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions.image_io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ImageHelper {
    private static final FileNameExtensionFilter filterBMP = new FileNameExtensionFilter("BMP (*.bmp)", "bmp");
    private static final FileNameExtensionFilter filterGIF = new FileNameExtensionFilter("GIF (*.gif)", "gif");
    private static final FileNameExtensionFilter filterJPEG = new FileNameExtensionFilter("JPEG (*.jpeg, *.jpg)", "jpg", "jpeg");
    private static final FileNameExtensionFilter filterPNG = new FileNameExtensionFilter("PNG (*.png)", "png");
    private static final FileNameExtensionFilter filterTIFF = new FileNameExtensionFilter("TIFF (*.tiff, *.tif)", "tif", "tiff");
    private static FileNameExtensionFilter[] filters = null;

    public static FileFilter[] getImageFileFilterList() {
        FileNameExtensionFilter[] l_preferredFilters;
        ArrayList<FileNameExtensionFilter> l_filters = new ArrayList<FileNameExtensionFilter>();
        for (FileNameExtensionFilter f : l_preferredFilters = ImageHelper.getPreferredFileNameExtensionFilters()) {
            Iterator<ImageWriter> l_it = ImageIO.getImageWritersBySuffix(f.getExtensions()[0]);
            if (l_it == null || !l_it.hasNext()) continue;
            l_filters.add(f);
        }
        return l_filters.toArray(new FileFilter[l_filters.size()]);
    }

    private FileFilter[] getChoosableImageFileFilterList() {
        String[] l_suffixes;
        ArrayList<FileNameExtensionFilter> l_filters = new ArrayList<FileNameExtensionFilter>();
        for (String s : l_suffixes = ImageIO.getReaderFileSuffixes()) {
            l_filters.add(new FileNameExtensionFilter(s, s));
        }
        return l_filters.toArray(new FileFilter[l_filters.size()]);
    }

    private static FileNameExtensionFilter[] getPreferredFileNameExtensionFilters() {
        if (filters == null) {
            filters = new FileNameExtensionFilter[5];
            ImageHelper.filters[0] = filterPNG;
            ImageHelper.filters[1] = filterBMP;
            ImageHelper.filters[2] = filterTIFF;
            ImageHelper.filters[3] = filterJPEG;
            ImageHelper.filters[4] = filterGIF;
        }
        return filters;
    }

    public static class ImageFileDescriptor {
        public final File file;
        public final String suffix;

        public ImageFileDescriptor(File file, String suffix) {
            this.file = file;
            this.suffix = suffix;
        }
    }

    public static class WriteImageTask
    implements Runnable {
        private final BufferedImage image;
        private final File file;
        private final String suffix;

        public WriteImageTask(BufferedImage image, String suffix, File file) {
            this.image = image;
            this.file = file;
            this.suffix = suffix;
        }

        @Override
        public void run() {
            try {
                ImageIO.write((RenderedImage)this.image, this.suffix, this.file);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

