/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions.filters;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.actions.image_io.ImageHelper;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.model.filters.SeamlessTextureFilter;
import com.valeras.colorwheel_harmony.ui.swing.panels.SeamlessTexturePanel;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class SeamlessTextureFilterAction
extends AbstractApplicationAction {
    private static final String STR_DIALOG_TITLE = "dialog.seamless_texture.title";
    private static final String STR_WRITING_IMAGE = "dialog.seamless_texture.msg.writing_image";
    private static final String STR_OVERSIZED = "dialog.seamless_texture.msg.oversized";
    private static final String STR_NO_IMAGE = "dialog.seamless_texture.msg.no_image";
    private static final String STR_PROCESSING = "dialog.seamless_texture.msg.processing";
    private static final String MENU_FILE = "menu.file.name";
    private static final String ACTION_LOAD_IMAGE = "action.file.load_image";
    private static final String STR_SEAMLESS = "Seamless ";
    private static final float PREFERRED_RESOLUTION = 128.0f;
    private static final int MAX_RESOLUTION = 1024;
    private double imageScale;

    public SeamlessTextureFilterAction() {
        super(SeamlessTextureFilterAction.getString("action.filter.seamless_texture"), "action.filter.seamless_texture");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ColorCombineToolkit l_toolkit = this.getColorCombineToolkit();
        BufferedImage l_image = l_toolkit.getImage();
        if (l_image == null) {
            this.showWarningDialog(MessageFormat.format(SeamlessTextureFilterAction.getString(STR_NO_IMAGE), SeamlessTextureFilterAction.getString(ACTION_LOAD_IMAGE), SeamlessTextureFilterAction.getString(MENU_FILE)), SeamlessTextureFilterAction.getString(STR_DIALOG_TITLE));
            return;
        }
        if (l_image.getWidth() > 1024 || l_image.getHeight() > 1024) {
            this.showWarningDialog(MessageFormat.format(SeamlessTextureFilterAction.getString(STR_OVERSIZED), Integer.toString(1024), Integer.toString(1024)), SeamlessTextureFilterAction.getString(STR_DIALOG_TITLE));
            return;
        }
        this.imageScale = (float)l_image.getWidth() > 128.0f ? (double)(128.0f / (float)l_image.getWidth()) : 1.0;
        this.setEnabled(false);
        PrepareGraphicsSwingWorker l_task = new PrepareGraphicsSwingWorker(l_image);
        this.showProgressMessage(SeamlessTextureFilterAction.getString(STR_PROCESSING), null);
        l_task.execute();
    }

    private void previewGraphics(SeamlessGraphics graphics) {
        String l_filename;
        ColorCombineToolkit l_toolkit = this.getColorCombineToolkit();
        File l_file = null;
        SeamlessTexturePanel l_panel = new SeamlessTexturePanel(graphics.originalTiling, graphics.seamlessTiling);
        int l_option = JOptionPane.showConfirmDialog(application.getMainWindow(), l_panel, SeamlessTextureFilterAction.getString(STR_DIALOG_TITLE), 2, -1);
        if (l_option != 0) {
            return;
        }
        Object l_imageSource = l_toolkit.getImageSource();
        if (l_imageSource instanceof File) {
            l_file = (File)l_imageSource;
            String l_parent = l_file.getParent();
            l_filename = l_parent + File.separator + STR_SEAMLESS + l_file.getName();
        } else {
            l_filename = STR_SEAMLESS + l_imageSource.toString();
        }
        l_file = new File(l_filename);
        ImageHelper.ImageFileDescriptor l_descriptor = this.getImageSaveAsFile(l_file, SeamlessTextureFilterAction.getString(STR_DIALOG_TITLE));
        if (l_descriptor == null) {
            return;
        }
        ImageHelper.WriteImageTask l_task = new ImageHelper.WriteImageTask(graphics.seamlessTexture, l_descriptor.suffix, l_descriptor.file);
        this.performLengthyTask(l_task, SeamlessTextureFilterAction.getString(STR_WRITING_IMAGE));
    }

    private static class SeamlessGraphics {
        public BufferedImage seamlessTexture;
        public TexturePaint originalTiling;
        public TexturePaint seamlessTiling;

        private SeamlessGraphics() {
        }
    }

    private class PrepareGraphicsSwingWorker
    extends SwingWorker<SeamlessGraphics, Object> {
        private final BufferedImage image;
        private final SeamlessTextureFilter filter;

        public PrepareGraphicsSwingWorker(BufferedImage image) {
            this.image = image;
            this.filter = new SeamlessTextureFilter();
        }

        @Override
        protected SeamlessGraphics doInBackground() throws Exception {
            SeamlessGraphics l_graphics = new SeamlessGraphics();
            BufferedImage l_seamlessTexture = null;
            l_graphics.seamlessTexture = l_seamlessTexture = this.filter.create(this.image);
            l_graphics.originalTiling = this.createTiling(this.image);
            l_graphics.seamlessTiling = this.createTiling(l_seamlessTexture);
            return l_graphics;
        }

        @Override
        protected void done() {
            SeamlessGraphics l_graphics;
            SeamlessTextureFilterAction.this.hideProgressMessage();
            SeamlessTextureFilterAction.this.setEnabled(true);
            try {
                l_graphics = (SeamlessGraphics)this.get();
            }
            catch (Exception ex) {
                Logger.getLogger(SeamlessTextureFilterAction.class.getName()).log(Level.SEVERE, null, ex);
                SeamlessTextureFilterAction.this.showErrorDialog(ex.getMessage(), SeamlessTextureFilterAction.getString(SeamlessTextureFilterAction.STR_DIALOG_TITLE));
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SeamlessTextureFilterAction.this.previewGraphics(l_graphics);
                }
            });
        }

        private TexturePaint createTiling(BufferedImage image) {
            BufferedImage l_image;
            if (SeamlessTextureFilterAction.this.imageScale != 1.0) {
                AffineTransformOp l_op = new AffineTransformOp(AffineTransform.getScaleInstance(SeamlessTextureFilterAction.this.imageScale, SeamlessTextureFilterAction.this.imageScale), 3);
                l_image = l_op.filter(image, null);
            } else {
                l_image = image;
            }
            Rectangle l_anchor = new Rectangle(0, 0, l_image.getWidth(), l_image.getHeight());
            return new TexturePaint(image, l_anchor);
        }
    }
}

