/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions.filters;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.model.filters.SearchColorCardFilter;
import java.awt.Color;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

public class OutlineColorCardFilterAction
extends AbstractApplicationAction {
    private static final String STR_PROCESSING = "filter.extract_colors.msg.processing";
    private static final String MENU_FILE = "menu.file.name";
    private static final String ACTION_LOAD_IMAGE = "action.file.load_image";
    private static final String STR_NO_IMAGE = "filter.outline_color.msg.no_image";
    private static final String STR_NO_COLOR = "filter.outline_color.msg.no_color";

    public OutlineColorCardFilterAction() {
        super(OutlineColorCardFilterAction.getString("action.filter.outline_color_card"), "action.filter.outline_color_card");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ColorCombineToolkit l_toolkit = this.getColorCombineToolkit();
        Color l_color = l_toolkit.getSelectedColor();
        if (l_color == null) {
            this.showWarningDialog(MessageFormat.format(OutlineColorCardFilterAction.getString(STR_NO_COLOR), OutlineColorCardFilterAction.getString(ACTION_LOAD_IMAGE), OutlineColorCardFilterAction.getString(MENU_FILE)), null);
            return;
        }
        BufferedImage l_image = l_toolkit.getImage();
        if (l_image == null) {
            this.showWarningDialog(MessageFormat.format(OutlineColorCardFilterAction.getString(STR_NO_IMAGE), OutlineColorCardFilterAction.getString(ACTION_LOAD_IMAGE), OutlineColorCardFilterAction.getString(MENU_FILE)), null);
            return;
        }
        FindColorSwingWorker l_task = new FindColorSwingWorker(l_image, l_color);
        this.showProgressMessage(OutlineColorCardFilterAction.getString(STR_PROCESSING), null);
        l_task.execute();
    }

    private class FindColorSwingWorker
    extends SwingWorker<Shape, Object> {
        private final BufferedImage image;
        private final Color color;
        private final SearchColorCardFilter filter;

        public FindColorSwingWorker(BufferedImage image, Color color) {
            this.image = image;
            this.color = color;
            this.filter = new SearchColorCardFilter(null, 16);
        }

        @Override
        protected Shape doInBackground() throws Exception {
            return this.filter.filter(this.image, this.color, true);
        }

        @Override
        protected void done() {
            OutlineColorCardFilterAction.this.hideProgressMessage();
            try {
                Shape l_shape = (Shape)this.get();
            }
            catch (Exception ex) {
                Logger.getLogger(OutlineColorCardFilterAction.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }
    }
}

