/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions.filters;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.actions.image_io.ImageHelper;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.ui.swing.panels.GradientPanel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class GradientFilterAction
extends AbstractApplicationAction {
    private static final String STR_DIALOG_TITLE = "dialog.gradient.title";
    private static final String STR_WRITING_IMAGE = "dialog.gradient.msg.writing_image";
    private static final String STR_NO_COLOR = "dialog.gradient.msg.no_color";
    private static final String MENU_FILE = "menu.file.name";
    private static final String ACTION_LOAD_IMAGE = "action.file.load_image";

    public GradientFilterAction() {
        super(GradientFilterAction.getString("action.filter.gradient"), "action.filter.gradient");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ColorCombineToolkit l_toolkit = this.getColorCombineToolkit();
        WriteImageAction l_action = new WriteImageAction();
        Color l_color = l_toolkit.getSelectedColor();
        if (l_color == null) {
            this.showWarningDialog(MessageFormat.format(GradientFilterAction.getString(STR_NO_COLOR), GradientFilterAction.getString(ACTION_LOAD_IMAGE), GradientFilterAction.getString(MENU_FILE)), GradientFilterAction.getString(STR_DIALOG_TITLE));
            return;
        }
        int l_index2 = l_toolkit.getSelectedPaletteEntryIndex() + 1;
        Color l_color2 = (Color)l_toolkit.getColorPalette().get(l_index2 >= l_toolkit.getColorPalette().size() ? 0 : l_index2);
        GradientPanel l_panel = new GradientPanel(l_color, l_color2, l_action);
        l_action.setPanel(l_panel);
        JOptionPane.showMessageDialog(application.getMainWindow(), l_panel, GradientFilterAction.getString(STR_DIALOG_TITLE), -1);
    }

    private class WriteImageAction
    extends AbstractAction {
        private GradientPanel panel = null;

        public void setPanel(GradientPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BufferedImage l_image = this.panel.getGradientImage();
            String l_name = this.panel.getGradientName();
            File l_file = new File(l_name + ".png");
            ImageHelper.ImageFileDescriptor l_descriptor = GradientFilterAction.this.getImageSaveAsFile(l_file, null);
            if (l_descriptor == null) {
                return;
            }
            ImageHelper.WriteImageTask l_task = new ImageHelper.WriteImageTask(l_image, l_descriptor.suffix, l_descriptor.file);
            GradientFilterAction.this.performLengthyTask(l_task, GradientFilterAction.getString(GradientFilterAction.STR_WRITING_IMAGE));
        }
    }
}

