/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions.filters;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.model.filters.ExtractColorFilter;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

public class ExtractColorsFilterAction
extends AbstractApplicationAction {
    private static final String STR_DIALOG_TITLE = "dialog.seamless_texture.title";
    private static final String STR_WRITING_IMAGE = "dialog.seamless_texture.msg.writing_image";
    private static final String STR_PROCESSING = "filter.extract_colors.msg.processing";
    private static final String MENU_FILE = "menu.file.name";
    private static final String ACTION_LOAD_IMAGE = "action.file.load_image";

    public ExtractColorsFilterAction() {
        super(ExtractColorsFilterAction.getString("action.filter.extract_colors"), "action.filter.extract_colors");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ColorCombineToolkit l_toolkit = this.getColorCombineToolkit();
        BufferedImage l_image = l_toolkit.getImage();
        if (l_image == null) {
            return;
        }
        ExtractColorsSwingWorker l_task = new ExtractColorsSwingWorker(l_image, this.getMainWindow().getImageColorPickerModel().getSamplesCount());
        this.showProgressMessage(ExtractColorsFilterAction.getString(STR_PROCESSING), null);
        l_task.execute();
    }

    private class ExtractColorsSwingWorker
    extends SwingWorker<Color[], Object> {
        private final BufferedImage image;
        private final ExtractColorFilter filter;
        private final int numColors;

        public ExtractColorsSwingWorker(BufferedImage image, int numColors) {
            this.image = image;
            this.numColors = numColors;
            this.filter = new ExtractColorFilter(null);
        }

        @Override
        protected Color[] doInBackground() throws Exception {
            Color[] l_colors = this.filter.extract(this.image, this.numColors);
            return l_colors;
        }

        @Override
        protected void done() {
            Color[] l_colors;
            ExtractColorsFilterAction.this.hideProgressMessage();
            try {
                l_colors = (Color[])this.get();
            }
            catch (Exception ex) {
                Logger.getLogger(ExtractColorsFilterAction.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
            System.out.println("*** extract colors finished ***");
            ExtractColorsFilterAction.this.getMainWindow().getImageColorPickerModel().setSampleColors(l_colors);
        }
    }
}

