/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions.development;

import com.valeras.app_skeleton.Application;
import com.valeras.colorwheel_harmony.app_core.AbstractColorWheelApplication;
import com.valeras.colorwheel_harmony.ui.swing.AbstractApplicationIconFactory;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class WriteApplicationIconsAction
extends AbstractAction {
    private static final String APP_ICON_SUFFIX = "app";
    private static final String DOC_ICON_SUFFIX = "doc";
    private static final String COLORCHART_ICON_SUFFIX = "cch";
    private static final String ICON_FORMAT = "png";

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractColorWheelApplication l_application = (AbstractColorWheelApplication)Application.getInstance();
        AbstractApplicationIconFactory l_factory = AbstractApplicationIconFactory.getInstance();
        JFileChooser l_fc = new JFileChooser();
        l_fc.setFileSelectionMode(1);
        l_fc.showOpenDialog(l_application.getMainWindow());
        File l_file = l_fc.getSelectedFile();
        if (l_file == null) {
            return;
        }
        File l_folder = l_file;
        this.writeIcons(l_factory.getApplicationIconImages(), l_folder, APP_ICON_SUFFIX);
        this.writeIcons(l_factory.getDocumentIconImages(), l_folder, DOC_ICON_SUFFIX);
        this.writeIcons(l_factory.getColorChartIconImages(), l_folder, COLORCHART_ICON_SUFFIX);
    }

    private void writeIcons(List<Image> images, File folder, String fileSuffix) {
        for (Image img : images) {
            int l_height = img.getHeight(null);
            File l_file = new File(folder, fileSuffix + String.valueOf(l_height) + "." + ICON_FORMAT);
            try {
                ImageIO.write((RenderedImage)((BufferedImage)img), ICON_FORMAT, l_file);
            }
            catch (IOException ex) {
                Logger.getLogger(WriteApplicationIconsAction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

