/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions.copy_protection;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.actions.copy_protection.CPOpenLicenseDialogAction;
import com.valeras.colorwheel_harmony.actions.copy_protection.CPOpenMessageDialogAction;
import com.valeras.colorwheel_harmony.actions.copy_protection.CPSetFunctionalityAction;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.copy_protection.CopyProtection;
import com.valeras.copy_protection.LicenseValidationPolicy;
import com.valeras.copy_protection.LicensingModel;
import com.valeras.copy_protection.ProductFunctionality;
import com.valeras.copy_protection.SecurityPolicy;
import com.valeras.copy_protection.event.SecurityNotificationEvent;
import com.valeras.copy_protection.policies.PropertyStoragePolicy;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Iterator;

public class CPReaction
extends AbstractApplicationAction {
    private static final String STR_STORAGE_CORRUPTED = "cp.message.security_corrupted";
    private static final String STR_EVALUATION_PERIOD_STARTED = "cp.message.evaluation_period.started";
    private static final String STR_EVALUATION_PERIOD_EXPIRED = "cp.message.evaluation_period.expired";
    private static final String STR_EVALUATION_PERIOD_REMINDER = "cp.message.evaluation_period.reminder";
    private static final String STR_LIMITED_FUNCTIONALITY = "cp.message.limited_functionality";
    private static final String STR_LOCKED_FUNCTIONALITY = "cp.message.locked_functionality";
    private static final String ACTION_NAME = "action.copy_protection.reaction";
    final CopyProtection cp = CopyProtection.getCopyProtection();
    final LicensingModel lm = this.cp.getLicensingModel();

    public CPReaction() {
        super(ACTION_NAME, (String)null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String l_message = null;
        int l_messageType = -1;
        LicenseValidationPolicy l_effectivePolicy = this.lm.getEffectivePolicy();
        SecurityPolicy l_failedPolicy = this.cp.getFailedPolicy();
        boolean l_expired = this.containsNotification(this.cp.notificationIterator(), "cp.policy.product_evaluation", 3);
        if (this.cp.hasNotification()) {
            CPOpenMessageDialogAction.showMessage(this.messageFor(this.cp.notificationIterator(), true), 1);
        }
        if (!this.cp.isLicenseValidated()) {
            if (l_failedPolicy instanceof PropertyStoragePolicy) {
                l_message = StringTable.get(STR_STORAGE_CORRUPTED);
                l_messageType = 0;
            } else if (l_effectivePolicy instanceof LicenseValidationPolicy) {
                ProductFunctionality l_func = this.lm.getProductFunctionality();
                if (l_func.equals((Object)ProductFunctionality.LIMITED_FUNCTIONALITY)) {
                    if (l_expired) {
                        l_message = StringTable.get(STR_LIMITED_FUNCTIONALITY);
                        l_messageType = 2;
                    }
                } else if (l_func.equals((Object)ProductFunctionality.LOCKED_FUNCTIONALITY)) {
                    l_message = StringTable.get(STR_LOCKED_FUNCTIONALITY);
                    l_messageType = 0;
                }
            }
        }
        if (l_message != null) {
            CPOpenLicenseDialogAction.openLicenseDialog(l_message, l_messageType);
        }
        CPSetFunctionalityAction.setFunctionality(this.lm.getProductFunctionality());
    }

    private boolean containsNotification(Iterator<SecurityNotificationEvent> notifications, String policy, int hint) {
        while (notifications.hasNext()) {
            SecurityNotificationEvent l_event = notifications.next();
            SecurityPolicy l_policy = (SecurityPolicy)l_event.getSource();
            if (!l_policy.getName().equalsIgnoreCase(policy) || l_event.getHint() != hint) continue;
            return true;
        }
        return false;
    }

    private String messageFor(SecurityNotificationEvent notification) {
        String l_message = null;
        if (notification.getSource().equals(this.lm.getPolicy("cp.policy.product_evaluation"))) {
            switch (notification.getHint()) {
                case 1: {
                    l_message = MessageFormat.format(StringTable.get(STR_EVALUATION_PERIOD_STARTED), notification.getValue());
                    break;
                }
                case 2: {
                    l_message = MessageFormat.format(StringTable.get(STR_EVALUATION_PERIOD_REMINDER), notification.getValue());
                    break;
                }
                case 3: {
                    l_message = MessageFormat.format(StringTable.get(STR_EVALUATION_PERIOD_EXPIRED), notification.getValue());
                }
            }
        }
        return l_message;
    }

    private String messageFor(Iterator<SecurityNotificationEvent> notifications, boolean clear) {
        String l_message = null;
        while (notifications.hasNext()) {
            SecurityNotificationEvent l_event = notifications.next();
            l_message = l_message == null ? "<html>" + this.messageFor(l_event) : l_message + "<br>" + this.messageFor(l_event);
            if (!clear) continue;
            notifications.remove();
        }
        return l_message;
    }
}

