/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions.copy_protection;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.ui.swing.panels.CPProductKeyPanel;
import com.valeras.copy_protection.CopyProtection;
import com.valeras.copy_protection.LicenseValidationPolicy;
import com.valeras.copy_protection.LicensingModel;
import com.valeras.copy_protection.attributes.ProductKeyAttribute;
import com.valeras.copy_protection.attributes.RegistrationInfoAttribute;
import com.valeras.copy_protection.policies.ProductKeyPolicy;
import com.valeras.copy_protection.policies.ProductKeyValidationPolicy;
import com.valeras.copy_protection.product_key.ProductKey;
import com.valeras.copy_protection.product_key.ProductKeyBuilder;
import com.valeras.copy_protection.product_key.ProductKeyFormat;
import com.valeras.copy_protection.product_key.ProductKeyParams;
import java.awt.event.ActionEvent;
import java.security.GeneralSecurityException;
import java.security.PermissionCollection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class CPOpenProductKeyDialogAction
extends AbstractApplicationAction {
    private static final String MSG_WRONG_INPUT = "dialog.enter_pak.wrong_input.message";
    private static final String MSG_PARSE_ERROR = "cp.message.wrong_product_key_format";
    private static final String MSG_WRONG_KEY = "cp.message.wrong_product_key";
    private static final String MSG_FAILED = "dialog.enter_pak.msg.failed";
    private static final String MSG_APPROVED = "cp.message.product_key.approved";
    private static final String STR_DIALOG_TITLE = "dialog.enter_pak.title";
    private static final String STR_MESSAGE_TITLE = "dialog.copy_protection.licensing.title";
    private final CopyProtection cp = CopyProtection.getCopyProtection();
    private final LicensingModel lm = this.cp != null ? this.cp.getLicensingModel() : null;
    private boolean approved = false;

    public CPOpenProductKeyDialogAction() {
        super(CPOpenProductKeyDialogAction.getString("action.copy_protection.enter_pak"), "action.copy_protection.enter_pak");
    }

    public boolean isProductKeyApproved() {
        return this.approved;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ProductKey l_productKey;
        ProductKeyParams l_params = new ProductKeyParams();
        PermissionCollection l_permissions = CopyProtection.RESET_SECUTITY.newPermissionCollection();
        this.approved = false;
        ProductKeyAttribute l_pakAttribute = (ProductKeyAttribute)this.cp.getAttribute("cp.attribute.product_key");
        ProductKeyBuilder l_keyBuilder = l_pakAttribute.getKeyBuilder();
        ProductKeyFormat l_keyFormat = ProductKeyFormat.getInstance((String)l_keyBuilder.getFormat());
        CPProductKeyPanel l_panel = new CPProductKeyPanel(l_keyFormat.getFormatSample());
        int l_option = JOptionPane.showConfirmDialog(application.getMainWindow(), l_panel, CPOpenProductKeyDialogAction.getString(STR_DIALOG_TITLE), 2, -1);
        if (l_option == 0) {
            if (!l_panel.isComplete()) {
                this.showErrorDialog(CPOpenProductKeyDialogAction.getString(MSG_WRONG_INPUT), CPOpenProductKeyDialogAction.getString(STR_DIALOG_TITLE));
                return;
            }
        } else {
            return;
        }
        String l_userName = l_panel.getUserName();
        String l_serialNumber = l_panel.getProductKey();
        ProductKeyValidationPolicy l_pakPolicy = (ProductKeyValidationPolicy)this.cp.getLicensingModel().getPolicy("cp.policy.license_validation.product_key");
        ProductKeyPolicy l_keyPolicy = (ProductKeyPolicy)this.cp.getPolicy("cp.policy.product_key");
        RegistrationInfoAttribute l_regInfoAttribute = (RegistrationInfoAttribute)this.cp.getAttribute("cp.attribute.registration_info");
        try {
            l_productKey = l_keyBuilder.parse(l_serialNumber);
        }
        catch (Exception ex) {
            Logger.getLogger(CPOpenProductKeyDialogAction.class.getName()).log(Level.SEVERE, null, ex);
            this.showErrorDialog(CPOpenProductKeyDialogAction.getString(MSG_PARSE_ERROR), CPOpenProductKeyDialogAction.getString(STR_MESSAGE_TITLE));
            return;
        }
        l_params.put("param.user_uid", (Object)l_userName);
        try {
            l_keyPolicy.checkActivate(l_productKey, l_params);
        }
        catch (GeneralSecurityException ex) {
            Logger.getLogger(CPOpenProductKeyDialogAction.class.getName()).log(Level.SEVERE, null, ex);
            this.showErrorDialog(CPOpenProductKeyDialogAction.getString(MSG_WRONG_KEY), CPOpenProductKeyDialogAction.getString(STR_MESSAGE_TITLE));
            return;
        }
        l_pakAttribute.setProductKey(l_productKey);
        l_regInfoAttribute.setEmail(l_userName);
        try {
            l_permissions.add(CopyProtection.RESET_SECUTITY);
            this.cp.reset(l_permissions);
            this.lm.revalidate((LicenseValidationPolicy)l_pakPolicy);
            this.approved = true;
            this.showInformationDialog(CPOpenProductKeyDialogAction.getString(MSG_APPROVED), CPOpenProductKeyDialogAction.getString(STR_MESSAGE_TITLE));
        }
        catch (GeneralSecurityException ex) {
            Logger.getLogger(CPOpenProductKeyDialogAction.class.getName()).log(Level.SEVERE, null, ex);
            this.showErrorDialog(CPOpenProductKeyDialogAction.getString(MSG_FAILED), CPOpenProductKeyDialogAction.getString(STR_MESSAGE_TITLE));
        }
    }

    public static boolean enterProductKey() {
        CPOpenProductKeyDialogAction l_action = new CPOpenProductKeyDialogAction();
        l_action.actionPerformed(null);
        return l_action.isProductKeyApproved();
    }
}

