/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.colorwheel_harmony.ui.swing.PaletteLayoutProvider;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorPalette;
import com.valeras.mdi.event.DocumentManagerListener;
import java.awt.Dimension;
import java.awt.event.ActionEvent;

public class ViewSelectPaletteLayoutAction
extends AbstractApplicationAction {
    private static final String COMMAND_PREFIX = "action.view.select_palette_layout.";
    private final String layout;
    private Dimension paletteSize;

    public ViewSelectPaletteLayoutAction(String layoutName) {
        super(StringTable.get(layoutName), ViewSelectPaletteLayoutAction.commandName(layoutName));
        this.layout = layoutName;
        this.paletteSize = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractColorDocument l_document = this.getSelectedDocument();
        if (l_document != null && !(e.getSource() instanceof DocumentManagerListener)) {
            l_document.setPaletteLayout(this.layout);
        }
        JxColorPalette l_component = this.getMainWindow().getColorPaletteComponent();
        if (this.paletteSize == null) {
            this.paletteSize = l_component.getPreferredSize();
            l_component.setPreferredSize(this.paletteSize);
        }
        l_component.setLayout(PaletteLayoutProvider.getPaletteLayout(this.layout));
        l_component.repaint();
        settings.setColorPaletteLayout(this.layout);
    }

    public static String commandName(String layoutName) {
        return COMMAND_PREFIX + layoutName;
    }
}

