/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.color_chart.ColorChart;
import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.app_core.features.ColorChartsFeature;
import com.valeras.colorwheel_harmony.model.ColorChartManager;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class ToolsSetMatchingColorChartAction
extends AbstractApplicationAction {
    private static final String COMMAND_PREFIX = "action.tools.match_color_chart.";
    private final ColorChartsFeature feature = (ColorChartsFeature)application.getFeature(12);
    private final Object colorChartId;

    public ToolsSetMatchingColorChartAction(String colorChartName) {
        super(colorChartName, ToolsSetMatchingColorChartAction.commandName(colorChartName));
        this.colorChartId = colorChartName;
        ColorChartManager l_manager = (ColorChartManager)this.feature.getFeaturedObject();
        ColorChart l_colorChart = l_manager.getColorChart(colorChartName);
        String l_name = l_colorChart.getDisplayName();
        this.putValue("Name", l_name);
    }

    public ToolsSetMatchingColorChartAction(int colorChartIndex) {
        super("dummy", ToolsSetMatchingColorChartAction.commandName(colorChartIndex));
        this.colorChartId = new Integer(colorChartIndex);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ColorChart l_colorChart;
        String l_command;
        ColorChartManager l_manager = this.feature.getManager();
        if (this.colorChartId instanceof String) {
            l_command = ToolsSetMatchingColorChartAction.commandName((String)this.colorChartId);
            l_colorChart = l_manager.getColorChart((String)this.colorChartId);
        } else {
            l_command = ToolsSetMatchingColorChartAction.commandName((Integer)this.colorChartId);
            l_colorChart = l_manager.getColorChart((Integer)this.colorChartId);
        }
        JMenuItem l_item = application.getMenuItem(l_command);
        if (l_item != null) {
            l_item.setSelected(true);
        }
        this.colorCombineToolkit.setColorMatchingColorSpace((ColorSpace)l_colorChart);
        settings.setMatchingColorSystem(l_colorChart.getName());
    }

    public static String commandName(String name) {
        return COMMAND_PREFIX + name;
    }

    public static String commandName(int index) {
        return COMMAND_PREFIX + Integer.toString(index).trim();
    }
}

