/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.color_chart.ColorChart;
import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.actions.ToolsSetMatchingColorChartAction;
import com.valeras.colorwheel_harmony.app_core.features.ColorChartsFeature;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class ToolsMatchColorChartPopupAction
extends AbstractApplicationAction {
    private static final String STR_TITLE = "menu.popup.color_chart";
    private final JComponent component;
    private final ColorChartsFeature feature;

    public ToolsMatchColorChartPopupAction(JComponent component) {
        super(ToolsMatchColorChartPopupAction.getString("action.tools.match_color_chart_popup"), "action.tools.match_color_chart_popup");
        this.component = component;
        this.feature = (ColorChartsFeature)application.getFeature(12);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JPopupMenu l_popup = new JPopupMenu(ToolsMatchColorChartPopupAction.getString(STR_TITLE));
        ButtonGroup l_group = new ButtonGroup();
        Collection<ColorChart> l_colorCharts = this.feature.getColorCharts();
        ColorSpace l_matchingColorSpace = this.colorCombineToolkit.getColorMatchingColorSpace();
        String l_selectedColorChart = l_matchingColorSpace != null && l_matchingColorSpace instanceof ColorChart ? ((ColorChart)l_matchingColorSpace).getName() : null;
        JRadioButtonMenuItem l_item = this.createRadioButtonMenuItem(application.getAction("action.tools.match_color_chart.none"));
        if (l_selectedColorChart == null) {
            l_item.setSelected(true);
        }
        l_group.add(l_item);
        l_popup.add(l_item);
        l_popup.addSeparator();
        for (ColorChart cc : l_colorCharts) {
            String l_name = cc.getName();
            l_item = this.createRadioButtonMenuItem(new ToolsSetMatchingColorChartAction(l_name));
            if (l_name.equals(l_selectedColorChart)) {
                l_item.setSelected(true);
            }
            l_group.add(l_item);
            l_popup.add(l_item);
        }
        l_popup.addSeparator();
        l_popup.add(new JMenuItem(application.getAction("action.view.color_chart_window")));
        l_popup.add(new JMenuItem(application.getAction("action.file.load_color_chart")));
        l_popup.show(this.component, -4, -4);
    }

    protected JRadioButtonMenuItem createRadioButtonMenuItem(AbstractApplicationAction action) {
        return new JRadioButtonMenuItem(action);
    }
}

