/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorimetry.CIE_ColourDifference;
import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.actions.ToolsCaptureScreenAction;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.model.filters.SearchColorCardFilter;
import com.valeras.colorwheel_harmony.ui.ApplicationMainWindow;
import com.valeras.colorwheel_harmony.ui.swing.components.JxSplitColor;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class ToolsColorSpyAction
extends AbstractApplicationAction {
    private static final String STR_NOT_SUPPORTED = "dialog.capture_screen.not_supported";
    private static final String STR_PROCESSING = "filter.extract_colors.msg.processing";
    public static final String STR_ERROR = "dialog.capture_screen.error";
    public static final String STR_COLOR_SPY = "feature.color_spy.name";
    public static final String STR_NO_COLOR = "dialog.color_spy.no_color";
    public static final String STR_NO_COLOR_CHART = "dialog.color_spy.no_color_chart";
    public static final String STR_COLOR_MESSAGE = "dialog.color_spy.message";
    public static final String STR_NOT_FOUND = "dialog.color_spy.no_nearest";
    public static final String STR_HOME_BUTTON = "dialog.color_spy.home_button";
    public static final String STR_HOME_TOOLTIP = "dialog.color_spy.home_tooltip";
    public static final String STR_LABEL_COLOR_SWATCH = "dialog.color_spy.label.color_swatch";
    public static final String STR_OPTION_CLICK = "dialog.color_spy.option.click";
    public static final String STR_OPTION_HOVER = "dialog.color_spy.option.hover";
    public static final String STR_OPTION_CANCEL = "dialog.color_spy.option.cancel";
    public static final String STR_MESSAGE_CLICK = "dialog.color_spy.message_click";
    private static final String STR_DELTA = "cie1976_delta";
    private static final String DEFAULT_DELTA_PATTERN = "0.00";
    private final CIE_ColourDifference formula;
    private final CIE_ColourDifference cie1976;

    public ToolsColorSpyAction(CIE_ColourDifference formula) {
        super(ToolsColorSpyAction.getString("action.tools.color_spy"), "action.tools.color_spy");
        this.formula = formula;
        this.cie1976 = CIE_ColourDifference.getInstance((int)1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ApplicationMainWindow l_window = this.getMainWindow();
        ColorCombineToolkit l_toolkit = this.getColorCombineToolkit();
        Color l_color = l_toolkit.getSelectedColor();
        if (l_color == null) {
            this.showWarningDialog(ToolsColorSpyAction.getString(STR_NO_COLOR), null);
            return;
        }
        l_window.setExtendedState(1);
        long l_delay = application.getSettings().getScreenCaptureDelayEnabled() ? 2000L : 0L;
        try {
            ToolsCaptureScreenAction.captureScreen(new DefaultImageObserver(l_color), l_delay);
        }
        catch (AWTException ex) {
            Logger.getLogger(ToolsColorSpyAction.class.getName()).log(Level.SEVERE, null, ex);
            this.showErrorDialog(ToolsColorSpyAction.getString(STR_NOT_SUPPORTED), null);
            l_window.setVisible(true);
            return;
        }
    }

    private class SearchColorChartSwingWorker
    extends SwingWorker<Shape, Object> {
        private final BufferedImage image;
        private final Color referenceColor;
        private Color sampleColor;
        private final SearchColorCardFilter filter;
        private final NumberFormat numberFormat;
        private final ColorCombineToolkit toolkit;

        public SearchColorChartSwingWorker(BufferedImage image, Color color) {
            this.image = image;
            this.referenceColor = color;
            this.filter = new SearchColorCardFilter(ToolsColorSpyAction.this.formula, 16);
            this.numberFormat = NumberFormat.getNumberInstance(Locale.US);
            this.numberFormat.setMinimumFractionDigits(1);
            this.numberFormat.setMaximumFractionDigits(1);
            this.toolkit = ToolsColorSpyAction.this.getColorCombineToolkit();
        }

        @Override
        protected Shape doInBackground() throws Exception {
            return this.filter.filter(this.image, this.referenceColor, true);
        }

        @Override
        protected void done() {
            Robot l_robot;
            Shape l_shape;
            ApplicationMainWindow l_mainWindow = ToolsColorSpyAction.this.getMainWindow();
            boolean l_cancel = false;
            ToolsColorSpyAction.this.hideProgressMessage();
            try {
                l_shape = (Shape)this.get();
            }
            catch (Exception ex) {
                Logger.getLogger(ToolsColorSpyAction.class.getName()).log(Level.SEVERE, null, ex);
                l_mainWindow.setExtendedState(0);
                ToolsColorSpyAction.this.showWarningDialog(AbstractApplicationAction.getString(ToolsColorSpyAction.STR_NO_COLOR_CHART), null);
                return;
            }
            try {
                l_robot = new Robot();
            }
            catch (AWTException ex) {
                Logger.getLogger(ToolsColorSpyAction.class.getName()).log(Level.SEVERE, null, ex);
                l_mainWindow.setExtendedState(0);
                ToolsColorSpyAction.this.showErrorDialog(AbstractApplicationAction.getString(ToolsColorSpyAction.STR_ERROR), null);
                return;
            }
            this.sampleColor = this.filter.getSampleColor();
            if (l_shape == null) {
                l_mainWindow.setExtendedState(0);
                ToolsColorSpyAction.this.showWarningDialog(AbstractApplicationAction.getString(ToolsColorSpyAction.STR_NOT_FOUND), null);
                return;
            }
            Rectangle l_rect = l_shape.getBounds();
            int l_x = (int)l_rect.getCenterX();
            int l_y = (int)l_rect.getCenterY();
            l_robot.mouseMove(l_x, l_y);
            switch (this.showColorSpyDialog(this.sampleColor, l_shape)) {
                case 0: {
                    l_robot.mouseMove(l_x, l_y);
                    l_robot.mousePress(16);
                    l_robot.mouseRelease(16);
                    break;
                }
                case 1: {
                    l_robot.mouseMove(l_x, l_y);
                    break;
                }
                case -1: 
                case 2: {
                    l_cancel = true;
                }
            }
            if (!l_cancel) {
                this.toolkit.getColorMatchingSystem().replaceSampleColor(this.sampleColor);
            } else {
                l_mainWindow.setExtendedState(0);
            }
        }

        private int showColorSpyDialog(Color color, Shape area) {
            JPanel l_panel = new JPanel(new GridBagLayout());
            Insets l_insets = new Insets(5, 0, 5, 5);
            float l_delta = ToolsColorSpyAction.this.cie1976.delta(this.referenceColor, color);
            JxSplitColor l_swatch = new JxSplitColor(4);
            l_swatch.setBorder(BorderFactory.createLineBorder(Color.gray));
            l_swatch.setBackground(this.referenceColor);
            l_swatch.setForeground(color);
            l_panel.add((Component)l_swatch, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, l_insets, 0, 0));
            l_panel.add((Component)new JLabel(MessageFormat.format(AbstractApplicationAction.getString(ToolsColorSpyAction.STR_LABEL_COLOR_SWATCH), AbstractApplicationAction.getString(ToolsColorSpyAction.STR_DELTA), this.numberFormat.format(l_delta))), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, l_insets, 0, 0));
            l_panel.add((Component)new JLabel(AbstractApplicationAction.getString(ToolsColorSpyAction.STR_MESSAGE_CLICK)), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, l_insets, 0, 0));
            return JOptionPane.showConfirmDialog(null, l_panel, AbstractApplicationAction.getString(ToolsColorSpyAction.STR_COLOR_SPY), 1, -1);
        }
    }

    private class DefaultImageObserver
    implements ImageObserver {
        private final Color color;

        public DefaultImageObserver(Color color) {
            this.color = color;
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            BufferedImage l_image = (BufferedImage)img;
            switch (infoflags) {
                case 32: {
                    SearchColorChartSwingWorker l_task = new SearchColorChartSwingWorker(l_image, this.color);
                    ToolsColorSpyAction.this.showProgressMessage(AbstractApplicationAction.getString(ToolsColorSpyAction.STR_PROCESSING), null);
                    l_task.execute();
                    break;
                }
                default: {
                    ToolsColorSpyAction.this.showErrorDialog(AbstractApplicationAction.getString(ToolsColorSpyAction.STR_ERROR), null);
                    ToolsColorSpyAction.this.getMainWindow().setVisible(true);
                }
            }
            return false;
        }
    }
}

