/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.ui.ApplicationMainWindow;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class ToolsCaptureScreenAction
extends AbstractApplicationAction {
    private static final String STR_IMAGE_SOURCE = "dialog.capture_screen.image_source";
    public static final String STR_NOT_SUPPORTED = "dialog.capture_screen.not_supported";
    public static final String STR_ERROR = "dialog.capture_screen.error";
    public static final long DEFAULT_DELAY = 2000L;

    public ToolsCaptureScreenAction() {
        super(ToolsCaptureScreenAction.getString("action.tools.capture_screen"), "action.tools.capture_screen");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ApplicationMainWindow l_window = this.getMainWindow();
        long l_delay = application.getSettings().getScreenCaptureDelayEnabled() ? 2000L : 0L;
        l_window.setVisible(false);
        try {
            ToolsCaptureScreenAction.captureScreen(new DefaultImageObserver(), l_delay);
        }
        catch (AWTException ex) {
            Logger.getLogger(ToolsCaptureScreenAction.class.getName()).log(Level.SEVERE, null, ex);
            this.showErrorDialog(ToolsCaptureScreenAction.getString(STR_NOT_SUPPORTED), null);
            l_window.setVisible(true);
        }
    }

    public static void captureScreen(final ImageObserver observer, long delay) throws AWTException {
        Toolkit l_toolkit = Toolkit.getDefaultToolkit();
        final Robot l_robot = new Robot();
        final long l_delay = delay;
        Dimension l_screenSize = l_toolkit.getScreenSize();
        final Rectangle l_rect = new Rectangle(0, 0, l_screenSize.width, l_screenSize.height);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BufferedImage l_image = null;
                if (l_delay > 0L) {
                    try {
                        Thread.sleep(l_delay);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(ToolsCaptureScreenAction.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                try {
                    l_image = l_robot.createScreenCapture(l_rect);
                }
                catch (RuntimeException re) {
                    Logger.getLogger(ToolsCaptureScreenAction.class.getName()).log(Level.SEVERE, null, re);
                }
                if (l_image != null) {
                    observer.imageUpdate(l_image, 32, 0, 0, l_image.getWidth(), l_image.getHeight());
                } else {
                    observer.imageUpdate(null, 64, 0, 0, 0, 0);
                }
            }
        });
    }

    private class DefaultImageObserver
    implements ImageObserver {
        private DefaultImageObserver() {
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            BufferedImage l_image = (BufferedImage)img;
            ToolsCaptureScreenAction.this.getMainWindow().setVisible(true);
            switch (infoflags) {
                case 32: {
                    ToolsCaptureScreenAction.this.getColorCombineToolkit().setImage(l_image, AbstractApplicationAction.getString(ToolsCaptureScreenAction.STR_IMAGE_SOURCE));
                    ToolsCaptureScreenAction.this.getMainWindow().selectColorTool("mode.color_picker");
                    break;
                }
                default: {
                    ToolsCaptureScreenAction.this.showErrorDialog(AbstractApplicationAction.getString(ToolsCaptureScreenAction.STR_ERROR), null);
                }
            }
            return false;
        }
    }
}

