/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.mdi.event.DocumentManagerListener;
import java.awt.event.ActionEvent;

public class SelectColorSchemeAction
extends AbstractApplicationAction {
    private static final String ACTION_NAME = "Select color scheme";
    private static final String COMMAND_PREFIX = "select_color_sceheme.";
    private final String colorScheme;

    public SelectColorSchemeAction(String colorSchemeName) {
        super(ACTION_NAME, SelectColorSchemeAction.commandName(colorSchemeName));
        this.colorScheme = colorSchemeName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractColorDocument l_document = this.getSelectedDocument();
        if (l_document != null && !(e.getSource() instanceof DocumentManagerListener)) {
            l_document.setColorScheme(this.colorScheme);
        }
        this.colorCombineToolkit.setSelectedColorScheme(this.colorScheme);
        application.getMainWindow().getColorSchemeSelectionPanel().setSelectedButton(SelectColorSchemeAction.commandName(this.colorScheme));
        settings.setColorScheme(this.colorScheme);
    }

    public static String commandName(String colorSchemeName) {
        return COMMAND_PREFIX + colorSchemeName;
    }
}

