/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.actions.image_io.ImageHelper;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;

public class FileWriteImageAction
extends AbstractApplicationAction {
    private static final String STR_WRITING_IMAGE = "action.file.write_image.msg.writing";
    private static final String STR_NO_IMAGE = "action.file.write_image.msg.no_image";

    public FileWriteImageAction() {
        super(FileWriteImageAction.getString("action.file.write_image"), "action.file.write_image");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String l_filename;
        ColorCombineToolkit l_toolkit = this.getColorCombineToolkit();
        File l_file = null;
        BufferedImage l_image = l_toolkit.getImage();
        if (l_image == null) {
            this.showWarningDialog(FileWriteImageAction.getString(STR_NO_IMAGE), null);
            return;
        }
        Object l_imageSource = l_toolkit.getImageSource();
        if (l_imageSource instanceof File) {
            l_file = (File)l_imageSource;
            l_filename = l_file.getAbsolutePath();
        } else {
            l_filename = l_imageSource.toString();
        }
        l_file = new File(l_filename);
        ImageHelper.ImageFileDescriptor l_descriptor = this.getImageSaveAsFile(l_file, null);
        if (l_descriptor == null) {
            return;
        }
        ImageHelper.WriteImageTask l_task = new ImageHelper.WriteImageTask(l_image, l_descriptor.suffix, l_descriptor.file);
        this.performLengthyTask(l_task, FileWriteImageAction.getString(STR_WRITING_IMAGE));
    }
}

