/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.actions.image_io.ImageHelper;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class FilePrintImageAction
extends AbstractApplicationAction {
    private static final String MSG_WRITING_IMAGE = "action.file.print_image.msg.writing_image";
    private static final int DEFAULT_IMAGE_WIDTH = 800;
    private static final int DEFAULT_IMAGE_HEIGHT = 600;

    public FilePrintImageAction() {
        super(FilePrintImageAction.getString("action.file.print_image"), "action.file.print_image");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractColorDocument l_document = this.getSelectedDocument();
        if (l_document == null) {
            return;
        }
        String l_name = l_document.getName();
        ImageHelper.ImageFileDescriptor l_descriptor = this.getImageSaveAsFile(new File(l_name), FilePrintImageAction.getString("action.file.print_image"));
        if (l_descriptor == null) {
            return;
        }
        PrintImageTask l_task = new PrintImageTask(l_descriptor.file, l_descriptor.suffix);
        this.performLengthyTask(l_task, FilePrintImageAction.getString(MSG_WRITING_IMAGE));
    }

    private void print(File file, String l_formatName) throws IOException {
        int l_width = 800;
        int l_height = 600;
        BufferedImage l_image = new BufferedImage(l_width, l_height, 1);
        Graphics2D l_g2 = l_image.createGraphics();
        l_g2.setColor(Color.white);
        l_g2.fillRect(0, 0, l_width, l_height);
        PageFormat l_pageFormat = this.pageFormatFor(l_image);
        Printable l_printable = this.getPrintManager().getPrintable();
        try {
            l_printable.print(l_g2, l_pageFormat, 0);
        }
        catch (PrinterException ex) {
            Logger.getLogger(FilePrintImageAction.class.getName()).log(Level.SEVERE, null, ex);
        }
        ImageIO.write((RenderedImage)l_image, l_formatName, file);
    }

    private PageFormat pageFormatFor(BufferedImage image) {
        PageFormat l_pageFormat = new PageFormat();
        Paper l_paper = new Paper();
        double l_width = image.getWidth();
        double l_height = image.getHeight();
        l_paper.setSize(l_width, l_height);
        l_paper.setImageableArea(0.0, 0.0, l_width, l_height);
        l_pageFormat.setPaper(l_paper);
        return l_pageFormat;
    }

    private class PrintImageTask
    implements Runnable {
        private final File file;
        private final String format;

        public PrintImageTask(File file, String format) {
            this.file = file;
            this.format = format;
        }

        @Override
        public void run() {
            try {
                FilePrintImageAction.this.print(this.file, this.format);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

